package com.liveperson.messaging.commands

import com.liveperson.infra.Command
import com.liveperson.infra.ICallback
import com.liveperson.infra.network.socket.SocketManager
import com.liveperson.messaging.network.socket.requests.CloseCobrowseDialogRequest
import org.json.JSONObject


/**
 * Class that represents a command to send request to update conversation's active Co-Browse
 * dialog when main dialog was resolved by consumer without ending of Co-browse session.
 * @param socketUrl url of current active socket
 * @param cobrowseDialogId id of the active Co-Browse call
 * @param conversationId id of previously active conversation
 * @param isVideo type of the active Co-Browse call
 * @param callback callback of executed command.
 */
class CloseCobrowseDialogCommand(
    private val socketUrl: String,
    private val cobrowseDialogId: String,
    private val conversationId: String,
    private val isVideo: Boolean,
    private var callback: ICallback<Int, Exception>? = null
): Command {

    companion object {

        private const val KEY_SESSION_STATE = "sessionState"
        private const val KEY_DIALOG_ID = "dialogId"
        private const val KEY_MODE = "mode"
        private const val KEY_NOTIFICATION_KEY = "notificationKey"

        private const val MODE_AUDIO = "AUDIO_CALL"
        private const val MODE_VIDEO = "VIDEO_CALL"
        private const val VALUE_SESSION_CLOSED = "CLOSED"
        private const val VALUE_NOTIFICATION_KEY = "ended_by_consumer"
    }

    override fun execute() {
        val mode = if (isVideo) {
            MODE_VIDEO
        } else {
            MODE_AUDIO
        }
        val metadata = JSONObject().apply {
            put(KEY_SESSION_STATE, VALUE_SESSION_CLOSED)
            put(KEY_DIALOG_ID, cobrowseDialogId)
            put(KEY_MODE, mode)
            put(KEY_NOTIFICATION_KEY, VALUE_NOTIFICATION_KEY)
        }
        val request = CloseCobrowseDialogRequest(
            socketUrl = socketUrl,
            cobrowseDialogId = cobrowseDialogId,
            conversationId = conversationId,
            coBrowseMetadata = metadata,
            callback = callback
        )
        SocketManager.getInstance().send(request)
    }
}