package com.liveperson.messaging.commands;

import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingChatMessage;

public class ReSendDocumentCommand extends SendDocumentCommand {

    private long mFileRowId;
    /**
     * Creates a command for sending messages
     */
    public ReSendDocumentCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String filePath, String fileTypeExtension, MaskedMessage message, String previewContentType, String eventId, long fileRowId) {
        super(controller, targetId, brandId, contentType, thumbnailPath, filePath, fileTypeExtension, message, previewContentType);

        mFileRowId = fileRowId;
        mEventId = eventId;
    }

    @Override
    protected void addMessageToDBAndSend(String conversationId, MaskedMessage message, MessagingChatMessage.MessageState state) {
        mController.amsMessages.updateMessageState(mEventId, MessagingChatMessage.MessageState.QUEUED);
        mController.amsMessages.getRowIdByEventId(mEventId).setPostQueryOnBackground(data -> {
            mMessageRowId = data;
            if (mCallback != null) {
                mCallback.onFileAddedToDB(mMessageRowId, mFileRowId, false);
            }
        }).execute();
    }

    @Override
    protected boolean canSendWhileOffline() {
        return false;
    }
}
