package com.liveperson.messaging.commands.tasks;

import com.liveperson.api.request.GetClock;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.ResponseCallback;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.otel.LPTelemetryManager;
import com.liveperson.infra.otel.LPTraceSpan;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.network.socket.general_requests.ClockRequest;

/**
 * Created by shiranr on 29/11/2015.
 */
public class GetClockTask extends BaseAmsSocketConnectionTask {

    private static final String TAG = "GetClockTask";

    private final Messaging mController;

    public GetClockTask(Messaging controller) {
        mController = controller;
    }

    @Override
    public void execute() {
	    LPLog.INSTANCE.i(TAG, "Running get clock task...");
        LPTraceSpan traceSpan = LPTelemetryManager.INSTANCE.begin(LPTraceType.UMS_GET_CLOCK_REQ);
        ClockRequest baseSocketRequest = new ClockRequest(mController.mConnectionController, mController.mAccountsController.getConnectionUrl(mBrandId), mBrandId);
        baseSocketRequest.addCallback(new ResponseCallback<GetClock.Response>() {
            @Override
            public void onSuccess(GetClock.Response data) {
                if (traceSpan != null) {
                    traceSpan.end();
                }
                mCallback.onTaskSuccess();
            }

            @Override
            public void onError() {
                if (traceSpan != null) {
                    traceSpan.cancel();
                }
                mCallback.onTaskError(SocketTaskType.GET_CLOCK, new Exception("get clock error"));
            }
        });
        SocketManager.getInstance().send(baseSocketRequest);
    }
}
