package com.liveperson.messaging.commands.tasks;

import android.text.TextUtils;

import com.liveperson.api.request.GetUserProfile;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.ResponseCallback;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.otel.LPTelemetryManager;
import com.liveperson.infra.otel.LPTraceSpan;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.network.socket.requests.GetUserProfileRequest;

/**
 * Created by Ilya Gazman on 11/16/2015.
 * <p/>
 * Base connection task to obtain user data
 */
public class GetConsumerUserTask extends BaseAmsSocketConnectionTask {

    private static final String TAG = "GetConsumerUserTask";
    private final Messaging mController;

    public GetConsumerUserTask(Messaging controller) {
        mController = controller;
    }

    @Override
    public void execute() {
        LPLog.INSTANCE.i(TAG, "Running GetConsumerUserTask task...");
        String consumerId = mController.amsUsers.getConsumerId(mBrandId);
        LPTraceSpan traceSpan = LPTelemetryManager.INSTANCE.begin(LPTraceType.UMS_GET_USER_PROFILE_REQ);

        if (!TextUtils.isEmpty(consumerId)) {
            if (traceSpan != null) {
                traceSpan.end();
            }
            LPLog.INSTANCE.d(TAG, "consumerId is not empty. Do not make a request.");
            mCallback.onTaskSuccess();
        } else {
            GetUserProfileRequest userProfileRequest = new GetUserProfileRequest(mController, mBrandId, UserProfile.UserType.CONSUMER);
            userProfileRequest.addCallback(new ResponseCallback<GetUserProfile.Response>() {
                private LocalBroadcastReceiver receiver;

                @Override
                public void onSuccess(GetUserProfile.Response data) {
                    if (traceSpan != null) {
                        traceSpan.end();
                    }
                    receiver = new LocalBroadcastReceiver.Builder()
                            .addAction(AmsUsers.BROADCAST_CONSUMER_ID_ACTION)
                            .build((context, intent) -> {
                                if (mBrandId.equals(intent.getStringExtra(AmsUsers.BRAND_ID_EXTRA))) {
                                    receiver.unregister();
                                    mCallback.onTaskSuccess();
                                }
                            });
                }

                @Override
                public void onError() {
                    if (traceSpan != null) {
                        traceSpan.cancel();
                    }
                    mCallback.onTaskError(SocketTaskType.GET_USER, new Exception(TAG));
                }
            });
            SocketManager.getInstance().send(userProfileRequest);
        }
    }
}
