package com.liveperson.messaging.commands.tasks

import com.liveperson.infra.ICallback
import com.liveperson.infra.configuration.Configuration
import com.liveperson.infra.log.LPLog
import com.liveperson.infra.messaging.R
import com.liveperson.infra.model.PushMessage
import com.liveperson.messaging.LpError
import com.liveperson.messaging.MessagingFactory
import com.liveperson.messaging.TaskType
import com.liveperson.messaging.commands.pusher.GetPendingProactiveMessagesCommand
import com.liveperson.messaging.commands.pusher.PusherHelper
import com.liveperson.messaging.controller.AccountsController

/**
 * Task to get pending proactive messages (PRMSG) in critical flow (show conversation)
 */
class GetPendingPRMSGTask(brandId: String, accountsController: AccountsController): BaseAmsAccountConnectionTask() {
    private val mAccountsController: AccountsController = accountsController
    private val brandId: String = brandId

    override fun execute() {
        LPLog.d(TAG, "Running GetPendingPRMSGTask task...")
        if (!Configuration.getBoolean(R.bool.lp_fetch_pending_proactive_messages) ||
            !Configuration.getBoolean(R.bool.show_outbound_in_app_message)) {
            LPLog.d(TAG, "Not sending request to get pending prmsg")
            mCallback.onTaskSuccess()
            return
        }

        val messagingController = MessagingFactory.getInstance().controller
        val pusherHelper = PusherHelper(this.brandId, messagingController)

        GetPendingProactiveMessagesCommand(
            messagingController,
            this.brandId,
            pusherHelper.getAppId(),
            mAccountsController.getLPAuthenticationParams(this.brandId),
            object : ICallback<List<PushMessage>, Exception>{
                override fun onSuccess(value: List<PushMessage>?) {
                    LPLog.d(TAG, "GetPendingProactiveMessagesCommand onSuccess ${value?.size}")
                    mCallback.onTaskSuccess()
                }

                override fun onError(exception: Exception?) {
                    LPLog.d(TAG, "GetPendingProactiveMessagesCommand onError ${exception?.message}")
                    mCallback.onTaskError(TaskType.GET_PENDING_PRMSG, LpError.UNKNOWN, exception)
                }
            }
        ).execute()
    }

    override fun getName(): String {
        return TAG
    }

    companion object {
        private const val TAG = "GetPendingPRMSGTask"
    }
}