package com.liveperson.messaging.hybrid.commands.messaging

import com.liveperson.infra.ICallback
import com.liveperson.messaging.Messaging
import com.liveperson.messaging.hybrid.commands.base.HybridSDKCommand
import com.liveperson.messaging.hybrid.commands.exceptions.EmptyMessageException
import com.liveperson.messaging.hybrid.commands.exceptions.HybridSDKException
import com.liveperson.messaging.hybrid.requireStateToSendMessage

/**
 * Implementation of hybrid sdk command to start file sharing flow with opening camera.
 * This command validates:
 * - whether value by key [PreferenceManager.KILL_SWITCH_PHOTO_SHARING_ENABLED_PREFERENCE_KEY] is set to true;
 * - whether value by key [PreferenceManager.SITE_SETTINGS_PHOTO_SHARING_ENABLED_PREFERENCE_KEY] is set to true;
 * - whether configuration [R.bool.enable_photo_sharing] is set to true.
 * Once all validations passed, command will send an intent to start photo picking flow.
 */
internal class SendMessageHybridSDKCommand(private val message: String) : HybridSDKCommand<Unit> {

    override fun execute(messaging: Messaging, callback: ICallback<Unit, HybridSDKException>) {
        val brandId = messaging.requireStateToSendMessage().activeBrandId!!
        if (message.isEmpty()) {
            callback.onError(EmptyMessageException("Sent message shouldn't be empty"))
            return
        }
        messaging.sendMessage(brandId, brandId, message, null, DelegatedCommandCallback(callback))
    }
}