package com.liveperson.messaging.model

/**
 * Enum to determine a user type received from server.
 *
 * - when received type equals to 0, then received message was sent by bot
 * - when received type equals to 1, then received message was sent by agent(human)
 * - when received type equals to 2, then received message was sent by controller(system)
 *
 * All other user types are marked as unknown and will not be processed by SDK.
 */
enum class AcUserType {
    CONTROLLER, HUMAN, BOT, UNKNOWN;

    companion object {
        @JvmStatic
        fun typeOfOrDefault(ordinal: Int, type: AcUserType): AcUserType {
            return values().getOrNull(ordinal) ?: type
        }
    }
}