package com.liveperson.messaging.model;

import com.liveperson.messaging.network.socket.requests.SendMessageRequest;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by shiranr on 12/07/2016.
 */
public class PendingDialogData {
	private ArrayList<SendMessageRequest> mPendingMessages = new ArrayList<>();

	public void addToPendingRequests(SendMessageRequest sendMessageRequest) {
		mPendingMessages.add(sendMessageRequest);
	}

	public void addToPendingRequests(List<SendMessageRequest> sendMessageRequest) {
		mPendingMessages.addAll(sendMessageRequest);
	}

	public void addToPendingRequests(int index, List<SendMessageRequest> sendMessageRequest) {
		mPendingMessages.addAll(index, sendMessageRequest);
	}

	public void clearPendingRequests() {
		mPendingMessages.clear();
	}

	public ArrayList<SendMessageRequest> getPendingMessages() {
		return mPendingMessages;
	}

	@Override
	public String toString() {
		return mPendingMessages.toString();
	}
}
