package com.liveperson.messaging.network.http

import com.liveperson.infra.Command
import com.liveperson.infra.ICallback
import com.liveperson.infra.errors.ErrorCode
import com.liveperson.infra.log.LPLog
import com.liveperson.infra.log.LPLog.d
import com.liveperson.infra.network.http.HttpHandler
import com.liveperson.infra.network.http.request.HttpGetRequest
import com.liveperson.infra.otel.LPTraceType

class GetPendingProactiveMessagesRequest(
    private val requestURL: String,
    private val token: String,
    private val certificates: List<String>? = null,
    private val callback: ICallback<String?, Exception?>? = null
) : Command {

    override fun execute() {
        val httpGetRequest = HttpGetRequest(requestURL, LPTraceType.PUSHER_GET_PENDING_PROACTIVE_MESSAGES_REQ)
        httpGetRequest.timeout = REQUEST_TIMEOUT
        addHeaders(httpGetRequest)
        httpGetRequest.certificatePinningKeys = certificates
        httpGetRequest.callback = setCallback()
        HttpHandler.execute(httpGetRequest)
    }

    private fun addHeaders(httpGetRequest: HttpGetRequest) {
        httpGetRequest.addHeader("Authorization", "Bearer $token")
    }

    private fun setCallback() : ICallback<String?, Exception?>? {
        return object : ICallback<String?, Exception?> {
            override fun onSuccess(value: String?) {
                d(TAG, "onSuccess $value")
                if (!value.isNullOrEmpty()) {
                    callback?.onSuccess(value)
                    return
                }
                callback?.onError(Exception("Get empty result"))
            }

            override fun onError(exception: Exception?) {
                LPLog.e(TAG, ErrorCode.ERR_0000016H, exception?.message!!)
                callback?.onError(exception)
            }
        }
    }

    companion object {
        private const val TAG = "GetPendingProactiveMessagesRequest"
        private const val REQUEST_TIMEOUT = 30000
    }
}