package com.liveperson.messaging.network.socket.general_requests;

import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.PendingMessagesRequest;
import com.liveperson.infra.network.socket.BaseResponseHandler;

/**
 * Purpose of this class is to reach out SocketHandler to send pending messages
 */
public class PendingMessagesSocketRequest extends BaseAMSSocketRequest<PendingMessagesRequest.Response, PendingMessagesSocketRequest> {

    private static final String TAG = "GeneralSocketRequest";

    public PendingMessagesSocketRequest(String socketUrl) {
        super(socketUrl);
    }

    @Override
    protected String getData() {
        return new PendingMessagesRequest().toJsonString(getRequestId());
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }

    @Override
    protected BaseResponseHandler<PendingMessagesRequest.Response, PendingMessagesSocketRequest> getResponseHandler() {
        return null;
    }
}
