package com.liveperson.messaging.network.socket.requests

import com.liveperson.api.request.BaseAMSSocketRequest
import com.liveperson.api.request.ReqBody.StringResp
import com.liveperson.api.request.UpdateConversationField
import com.liveperson.infra.ICallback
import com.liveperson.infra.log.LPLog.d
import com.liveperson.infra.log.LPLog.w
import com.liveperson.infra.network.socket.BaseResponseHandler
import com.liveperson.messaging.model.ConversationField
import org.json.JSONObject
import java.lang.Exception

/**
 * Request to update conversation participant.
 */
class UpdateConversationFieldRequest(socketUrl: String, val conversationId: String, val conversationFieldList: ArrayList<ConversationField>) :
    BaseAMSSocketRequest <StringResp, UpdateConversationFieldRequest>(socketUrl) {

    private val TAG = "UpdateConversationFieldRequest"
    private var callback: ICallback<String?, Throwable?>? = null

    fun setResponseCallBack(callBack: ICallback<String?, Throwable?>) {
        this.callback = callBack
    }

    override fun getData(): String {
        return UpdateConversationField(conversationId, UpdateConversationField.PARTICIPANTS_CHANGE_FIELD, conversationFieldList).toJsonString(requestId)
    }

    override fun getRequestName(): String = TAG

    override fun getResponseHandler(): BaseResponseHandler<StringResp, UpdateConversationFieldRequest> {
        return object : BaseResponseHandler<StringResp, UpdateConversationFieldRequest>() {
            override fun parse(jsonObject: JSONObject?): StringResp {
                return StringResp(jsonObject)
            }

            override fun handle(response: StringResp?): Boolean {
                if (response?.code!! > 201) {
                    w(TAG, "Received bad response ( ${response.code} ).")
                    callback?.onError(Exception("Failed to update conversation field, response: $response"))
                } else {
                    d(TAG, "Successfully updated conversation fields: $response")
                    callback?.onSuccess(response.body)
                }
                return true
            }

            override fun getAPIResponseType(): String? {
                return null
            }
        }
    }
}