package com.liveperson.messaging.provider

import com.liveperson.messaging.model.FileMessage

interface FileMessageProvider {

    /**
     * Get [FileMessage] from the database based on the associated message row id
     * @param messageRowId message row id
     * @return file message if found in the database, null otherwise
     */
    fun getFileByMessageRowId(messageRowId: Long): FileMessage?

}