/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.Command;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.network.socket.requests.ChatStateChangeRequest;

public class ChangeChatStateCommand
implements Command {
    private final AmsDialogs mDialogs;
    private ChatState mState;
    private String mSocketUrl;

    public ChangeChatStateCommand(AmsDialogs amsDialogs, String socketUrl, ChatState state) {
        this.mDialogs = amsDialogs;
        this.mSocketUrl = socketUrl;
        this.mState = state;
    }

    public void execute() {
        Dialog dialog = this.mDialogs.getActiveDialog();
        if (dialog != null && dialog.getState() == DialogState.OPEN) {
            SocketManager.getInstance().send((BaseSocketRequest)new ChatStateChangeRequest(this.mSocketUrl, dialog.getDialogId(), dialog.getConversationId(), this.mState));
        }
    }
}

