/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import androidx.annotation.NonNull;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.infra.utils.UniqueID;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.SendMessageCommand;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.network.socket.requests.SendMessageRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class SendMessageWithURLCommand
extends SendMessageCommand {
    private static final String TAG = "SendMessageWithURLCommand";
    private String mDescription;
    private String mTitle;
    private String mImageUrl;
    private String mURLToParse;
    private String mSiteName;

    public SendMessageWithURLCommand(Messaging controller, String targetId, String brandId, MaskedMessage message, String urlToParse, String title, String description, String imageURL, String siteName) {
        super(controller, targetId, brandId, message);
        this.mBrandId = brandId;
        this.mTargetId = targetId;
        this.mMessage = message;
        this.mDescription = description;
        this.mTitle = title;
        this.mURLToParse = urlToParse;
        this.mImageUrl = imageURL;
        this.mSiteName = siteName;
    }

    private JSONObject generateJSON(String msg) {
        try {
            JSONObject json = new JSONObject();
            JSONObject messageWithURL = new JSONObject();
            messageWithURL.put("title", (Object)this.mTitle);
            messageWithURL.put("description", (Object)this.mDescription);
            messageWithURL.put("image_url", (Object)this.mImageUrl);
            messageWithURL.put("original_message", (Object)msg);
            messageWithURL.put("original_url_to_parse", (Object)this.mURLToParse);
            messageWithURL.put("site_name_url_to_parse", (Object)this.mSiteName);
            json.put("message_with_url", (Object)messageWithURL);
            return json;
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000D4, "generateJSON exception", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void sendMessageIfDialogIsOpen() {
        Dialog dialog = this.mController.amsDialogs.getActiveDialog();
        if (dialog != null) {
            LPLog.INSTANCE.d(TAG, "sendMessageIfDialogIsOpen: " + (Object)((Object)dialog.getState()));
            if (dialog.getState() == DialogState.OPEN) {
                SendMessageRequest sendMessageRequest = this.createMessageRequest(this.mController, this.mEventId, this.mTargetId, this.mBrandId, dialog.getDialogId(), dialog.getConversationId());
                this.sendMessage(dialog.getDialogId(), sendMessageRequest);
            } else if (dialog.getState() == DialogState.PENDING) {
                SendMessageRequest sendMessageRequest = this.createMessageRequest(this.mController, this.mEventId, this.mTargetId, this.mBrandId, null, null);
                dialog.getPendingData().addToPendingRequests(sendMessageRequest);
            }
        }
    }

    @Override
    @NonNull
    protected MessagingChatMessage createNewChatMessage(String dialogId, MaskedMessage message, MessagingChatMessage.MessageState state) {
        MessagingChatMessage.MessageType messageType = message.isMasked() ? MessagingChatMessage.MessageType.CONSUMER_URL_MASKED : MessagingChatMessage.MessageType.CONSUMER_URL;
        return new MessagingChatMessage(this.mConsumerId, message.getDbMessage(), System.currentTimeMillis(), dialogId, this.mEventId, messageType, state, EncryptionVersion.NONE);
    }

    @Override
    protected void addMessageToDBAndSend(String dialogId, MaskedMessage message, MessagingChatMessage.MessageState messageState) {
        String finalMsg = this.generateJSON(message.getDbMessage()).toString();
        message.setDbMessage(finalMsg);
        this.mEventId = UniqueID.createUniqueMessageEventId();
        LPLog.INSTANCE.i(TAG, "addMessageWithURLToDBAndSend: mEventId = " + this.mEventId + " dialog id = " + message);
        MessagingChatMessage chatMessage = this.createNewChatMessage(dialogId, message, messageState);
        LPLog.INSTANCE.i(TAG, "addMessageWithURLToDBAndSend: chatMessage.MessageType = " + (Object)((Object)chatMessage.getMessageType()) + " MessageState() = " + (Object)((Object)chatMessage.getMessageState()));
        this.mController.amsMessages.addMessage(chatMessage, true).setPreQueryOnBackground(() -> this.attachMessageToOfflineModeIfNeeded(chatMessage)).setPostQueryOnBackground(data -> {
            LPLog.INSTANCE.i(TAG, "Send message, time: " + chatMessage.getTimeStamp());
            if (chatMessage.getMessageState() != MessagingChatMessage.MessageState.OFFLINE) {
                this.sendMessageIfDialogIsOpen();
            }
        }).execute();
        if (this.mMessage.isMasked()) {
            String maskedEventId = this.mEventId + "-mm";
            MessagingChatMessage warning = new MessagingChatMessage(chatMessage.getOriginatorId(), message.getMaskedSystemMessage(), chatMessage.getTimeStamp() + 1L, chatMessage.getDialogId(), maskedEventId, MessagingChatMessage.MessageType.SYSTEM_MASKED, MessagingChatMessage.MessageState.RECEIVED, -3, ContentType.text_plain.getText(), EncryptionVersion.NONE);
            this.mController.amsMessages.addMessage(warning, true).execute();
        }
    }
}

