/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.model.PushMessage;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.pusher.GetPendingProactiveMessagesCommand;
import com.liveperson.messaging.commands.pusher.PusherHelper;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/liveperson/messaging/commands/tasks/GetPendingPRMSGTask;", "Lcom/liveperson/messaging/commands/tasks/BaseAmsAccountConnectionTask;", "brandId", "", "accountsController", "Lcom/liveperson/messaging/controller/AccountsController;", "(Ljava/lang/String;Lcom/liveperson/messaging/controller/AccountsController;)V", "mAccountsController", "execute", "", "getName", "Companion", "messaging_release"})
public final class GetPendingPRMSGTask
extends BaseAmsAccountConnectionTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AccountsController mAccountsController;
    @NotNull
    private final String brandId;
    @NotNull
    private static final String TAG = "GetPendingPRMSGTask";

    public GetPendingPRMSGTask(@NotNull String brandId, @NotNull AccountsController accountsController) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)accountsController, (String)"accountsController");
        this.mAccountsController = accountsController;
        this.brandId = brandId;
    }

    public void execute() {
        LPLog.INSTANCE.d(TAG, "Running GetPendingPRMSGTask task...");
        if (!Configuration.getBoolean((int)R.bool.lp_fetch_pending_proactive_messages) || !Configuration.getBoolean((int)R.bool.show_outbound_in_app_message)) {
            LPLog.INSTANCE.d(TAG, "Not sending request to get pending prmsg");
            this.mCallback.onTaskSuccess();
            return;
        }
        Messaging messagingController = MessagingFactory.getInstance().getController();
        Intrinsics.checkNotNullExpressionValue((Object)messagingController, (String)"messagingController");
        PusherHelper pusherHelper = new PusherHelper(this.brandId, messagingController);
        String string2 = pusherHelper.getAppId();
        LPAuthenticationParams lPAuthenticationParams = this.mAccountsController.getLPAuthenticationParams(this.brandId);
        Intrinsics.checkNotNullExpressionValue((Object)lPAuthenticationParams, (String)"mAccountsController.getL\u2026ationParams(this.brandId)");
        new GetPendingProactiveMessagesCommand(messagingController, this.brandId, string2, lPAuthenticationParams, (ICallback<List<PushMessage>, Exception>)((ICallback)new ICallback<List<? extends PushMessage>, Exception>(this){
            final /* synthetic */ GetPendingPRMSGTask this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable List<? extends PushMessage> value) {
                List<? extends PushMessage> list = value;
                LPLog.INSTANCE.d("GetPendingPRMSGTask", "GetPendingProactiveMessagesCommand onSuccess " + (list != null ? Integer.valueOf(list.size()) : null));
                this.this$0.mCallback.onTaskSuccess();
            }

            public void onError(@Nullable Exception exception) {
                Exception exception2 = exception;
                LPLog.INSTANCE.d("GetPendingPRMSGTask", "GetPendingProactiveMessagesCommand onError " + (exception2 != null ? exception2.getMessage() : null));
                this.this$0.mCallback.onTaskError(TaskType.GET_PENDING_PRMSG, LpError.UNKNOWN, exception);
            }
        })).execute();
    }

    @Override
    @NotNull
    public String getName() {
        return TAG;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/messaging/commands/tasks/GetPendingPRMSGTask$Companion;", "", "()V", "TAG", "", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

