/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.offline;

import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.WorkerThread;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.database.BaseDBRepository;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.cache.ConversationsCacheProvider;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.offline.api.OfflineConversationRepository;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/liveperson/messaging/offline/OfflineConversationRepositoryImpl;", "Lcom/liveperson/infra/database/BaseDBRepository;", "Lcom/liveperson/messaging/offline/api/OfflineConversationRepository;", "conversationsCacheProvider", "Lcom/liveperson/messaging/cache/ConversationsCacheProvider;", "(Lcom/liveperson/messaging/cache/ConversationsCacheProvider;)V", "clearOfflineConversation", "", "targetId", "", "createAndSaveOfflineConversation", "Lcom/liveperson/messaging/model/Conversation;", "brandId", "requestId", "", "getOrCreateOfflineConversation", "queryOfflineConversation", "queryRealConversationsCount", "", "Companion", "messaging_release"})
@SourceDebugExtension(value={"SMAP\nOfflineConversationRepositoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfflineConversationRepositoryImpl.kt\ncom/liveperson/messaging/offline/OfflineConversationRepositoryImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class OfflineConversationRepositoryImpl
extends BaseDBRepository
implements OfflineConversationRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConversationsCacheProvider conversationsCacheProvider;
    @NotNull
    private static final String TAG = "OfflineConversationRepositoryImpl";

    public OfflineConversationRepositoryImpl(@NotNull ConversationsCacheProvider conversationsCacheProvider) {
        Intrinsics.checkNotNullParameter((Object)conversationsCacheProvider, (String)"conversationsCacheProvider");
        super("conversations");
        this.conversationsCacheProvider = conversationsCacheProvider;
    }

    @Override
    @WorkerThread
    @NotNull
    public Conversation getOrCreateOfflineConversation(@NotNull String targetId, @NotNull String brandId, long requestId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Conversation conversation = this.conversationsCacheProvider.getConversationFromCache("OFFLINE_CONVERSATION");
        if (conversation == null && (conversation = this.queryOfflineConversation(targetId, brandId)) == null) {
            conversation = this.createAndSaveOfflineConversation(targetId, brandId, requestId);
        }
        Conversation currentOfflineConversation = conversation;
        this.conversationsCacheProvider.cacheConversation(currentOfflineConversation);
        return currentOfflineConversation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int queryRealConversationsCount() {
        String whereClause = "conversation_id != ? AND conversation_id != ?";
        Object object = new String[]{"TEMP_CONVERSATION", "OFFLINE_CONVERSATION"};
        String[] whereArgs = object;
        try {
            object = (Closeable)this.getDB().query(null, whereClause, whereArgs, null, null, null);
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)object;
                boolean bl = false;
                int n = cursor.getCount();
                return n;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            LPLog.INSTANCE.d(TAG, "Error occurred while getting real conversation count", (Throwable)exception);
            return -1;
        }
    }

    @Override
    public void clearOfflineConversation(@NotNull String targetId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        String whereClause = "conversation_id = ? AND target_id = ?";
        String[] stringArray = new String[]{"OFFLINE_CONVERSATION", targetId};
        String[] whereArgs = stringArray;
        this.getDB().removeAll(whereClause, whereArgs);
        this.conversationsCacheProvider.removeConversationFromCache(targetId, "OFFLINE_CONVERSATION");
        LPLog.INSTANCE.d(TAG, "Finished removing offline conversation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Conversation queryOfflineConversation(String targetId, String brandId) {
        Object object;
        block11: {
            Object object2;
            String query = "conversation_id = ? AND target_id = ? AND brand_id = ? AND state = ?";
            object = new String[]{"OFFLINE_CONVERSATION", targetId, brandId, String.valueOf(ConversationState.OFFLINE.ordinal())};
            String[] arguments = object;
            object = this;
            try {
                Conversation conversation;
                OfflineConversationRepositoryImpl $this$queryOfflineConversation_u24lambda_u244 = (OfflineConversationRepositoryImpl)object;
                boolean bl = false;
                Cursor cursor = $this$queryOfflineConversation_u24lambda_u244.getDB().query(null, query, arguments, null, null, null, "1");
                if (cursor != null) {
                    Closeable closeable = (Closeable)cursor;
                    Throwable throwable = null;
                    try {
                        Conversation conversation2;
                        Cursor cursor2;
                        Cursor it = (Cursor)closeable;
                        boolean bl2 = false;
                        Cursor it2 = cursor2 = it;
                        boolean bl3 = false;
                        Object object3 = it2.moveToFirst() ? cursor2 : null;
                        if (object3 != null) {
                            it2 = object3;
                            boolean bl4 = false;
                            conversation2 = new Conversation(it2);
                        } else {
                            conversation2 = null;
                        }
                        Conversation conversation3 = conversation2;
                        conversation = conversation3;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    conversation = null;
                }
                object2 = Result.constructor-impl(conversation);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block11;
            Object it = object2 = throwable;
            boolean bl = false;
            LPLog.INSTANCE.d(TAG, "Failed to query offline conversation", (Throwable)it);
        }
        return (Conversation)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private final Conversation createAndSaveOfflineConversation(String targetId, String brandId, long requestId) {
        Conversation conversation = new Conversation(targetId, brandId);
        conversation.setConversationId("OFFLINE_CONVERSATION");
        conversation.setState(ConversationState.OFFLINE);
        conversation.setConversationTTRType(TTRType.NORMAL);
        conversation.setRequestId(requestId);
        conversation.setUnreadMessages(-1);
        conversation.setStartTimestamp(System.currentTimeMillis());
        ContentValues insertValues = new ContentValues();
        insertValues.put("brand_id", conversation.getBrandId());
        insertValues.put("target_id", conversation.getTargetId());
        insertValues.put("conversation_id", conversation.getConversationId());
        insertValues.put("state", Integer.valueOf(conversation.getState().ordinal()));
        insertValues.put("ttr_type", Integer.valueOf(conversation.getConversationTTRType().ordinal()));
        insertValues.put("unread_msg_count", Integer.valueOf(-1));
        insertValues.put("start_timestamp", Long.valueOf(conversation.getStartTimestamp()));
        insertValues.put("request_id", Long.valueOf(conversation.getRequestId()));
        this.getDB().insert(insertValues);
        return conversation;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/messaging/offline/OfflineConversationRepositoryImpl$Companion;", "", "()V", "TAG", "", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

