/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.offline;

import android.content.ContentValues;
import android.database.Cursor;
import android.text.TextUtils;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.database.BaseDBRepository;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.messaging.model.AmsMessages;
import com.liveperson.messaging.model.FileMessage;
import com.liveperson.messaging.model.FullMessageRow;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.offline.api.OfflineMessagesRepository;
import com.liveperson.messaging.provider.FileMessageProvider;
import com.liveperson.messaging.provider.FileUploadProgressProvider;
import com.liveperson.messaging.utils.CollectionsUtilsKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0002)*B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J+\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000fH\u0016J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\"\u001a\u00020!H\u0016J\u0018\u0010#\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010%\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u000fH\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/liveperson/messaging/offline/OfflineMessagesRepositoryImpl;", "Lcom/liveperson/infra/database/BaseDBRepository;", "Lcom/liveperson/messaging/offline/api/OfflineMessagesRepository;", "preferenceManager", "Lcom/liveperson/infra/managers/PreferenceManager;", "fileMessageProvider", "Lcom/liveperson/messaging/provider/FileMessageProvider;", "fileUploadProgressProvider", "Lcom/liveperson/messaging/provider/FileUploadProgressProvider;", "offlineMessagesListener", "Lcom/liveperson/messaging/offline/OfflineMessagesRepositoryImpl$OfflineMessagesListener;", "(Lcom/liveperson/infra/managers/PreferenceManager;Lcom/liveperson/messaging/provider/FileMessageProvider;Lcom/liveperson/messaging/provider/FileUploadProgressProvider;Lcom/liveperson/messaging/offline/OfflineMessagesRepositoryImpl$OfflineMessagesListener;)V", "areOfflineMessagesExists", "", "brandId", "", "getPendingMessagesQuery", "rowIds", "getPendingMessagesQueryParams", "", "state", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "getPendingOfflineMessages", "", "isMessagePending", "eventId", "isOfflineWelcomeMessageExists", "dialogId", "loadOfflineMessagesExcept", "", "Lcom/liveperson/messaging/model/FullMessageRow;", "eventIds", "removeMessage", "", "removeOfflineWelcomeMessage", "removePendingOfflineMessage", "removePendingOfflineMessages", "setPendingOfflineMessages", "triggerUpdateMessagesForDialogId", "updateOfflineMessagesDialogId", "actualDialogId", "Companion", "OfflineMessagesListener", "messaging_release"})
@SourceDebugExtension(value={"SMAP\nOfflineMessagesRepositoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfflineMessagesRepositoryImpl.kt\ncom/liveperson/messaging/offline/OfflineMessagesRepositoryImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n1#2:276\n*E\n"})
public final class OfflineMessagesRepositoryImpl
extends BaseDBRepository
implements OfflineMessagesRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PreferenceManager preferenceManager;
    @NotNull
    private final FileMessageProvider fileMessageProvider;
    @NotNull
    private final FileUploadProgressProvider fileUploadProgressProvider;
    @NotNull
    private final OfflineMessagesListener offlineMessagesListener;
    @NotNull
    private static final String TAG = "OfflineMessagesRepositoryImpl";
    @NotNull
    private static final String KEY_OFFLINE_MESSAGES_EVENTS = "OFFLINE_MESSAGES_EVENTS";

    public OfflineMessagesRepositoryImpl(@NotNull PreferenceManager preferenceManager, @NotNull FileMessageProvider fileMessageProvider, @NotNull FileUploadProgressProvider fileUploadProgressProvider, @NotNull OfflineMessagesListener offlineMessagesListener) {
        Intrinsics.checkNotNullParameter((Object)preferenceManager, (String)"preferenceManager");
        Intrinsics.checkNotNullParameter((Object)fileMessageProvider, (String)"fileMessageProvider");
        Intrinsics.checkNotNullParameter((Object)fileUploadProgressProvider, (String)"fileUploadProgressProvider");
        Intrinsics.checkNotNullParameter((Object)offlineMessagesListener, (String)"offlineMessagesListener");
        super("messages");
        this.preferenceManager = preferenceManager;
        this.fileMessageProvider = fileMessageProvider;
        this.fileUploadProgressProvider = fileUploadProgressProvider;
        this.offlineMessagesListener = offlineMessagesListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<FullMessageRow> loadOfflineMessagesExcept(@NotNull String brandId, @NotNull Set<String> eventIds) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter(eventIds, (String)"eventIds");
        String rowIds = this.fileUploadProgressProvider.getInProgressUploadMessageRowIdsString();
        String[] whereArgs = this.getPendingMessagesQueryParams(brandId, rowIds, String.valueOf(DialogState.OPEN.ordinal()));
        String where = this.getPendingMessagesQuery(rowIds);
        List offlineMessages = new ArrayList();
        try {
            Closeable closeable = (Closeable)this.getDB().query(null, where, whereArgs, null, null, null);
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)closeable;
                boolean bl = false;
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        MessagingChatMessage message;
                        if (!MessagingChatMessage.MessageType.isConsumer((message = AmsMessages.getSingleMessageFromCursor(cursor)).getMessageType()) || eventIds.contains(message.getEventId())) continue;
                        FileMessage fileMessage = null;
                        if (MessagingChatMessage.MessageType.isConsumerFile(message.getMessageType())) {
                            fileMessage = this.fileMessageProvider.getFileByMessageRowId(message.getLocalId());
                        }
                        offlineMessages.add(new FullMessageRow(message, null, fileMessage));
                    } while (cursor.moveToNext());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            LPLog.INSTANCE.d(TAG, "Failed to query offline messages", (Throwable)exception);
        }
        return offlineMessages;
    }

    @Override
    public void removeMessage(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        String whereClause = "eventId = ?";
        String[] stringArray = new String[]{eventId};
        String[] whereArgs = stringArray;
        this.getDB().removeAll(whereClause, whereArgs);
        this.offlineMessagesListener.removeMessageByEventId(eventId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areOfflineMessagesExists(@NotNull String brandId) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        String[] $this$areOfflineMessagesExists_u24lambda_u241 = stringArray = new StringBuilder();
        boolean bl = false;
        $this$areOfflineMessagesExists_u24lambda_u241.append("JOIN dialogs ON ");
        $this$areOfflineMessagesExists_u24lambda_u241.append("dialogs.dialog_id");
        $this$areOfflineMessagesExists_u24lambda_u241.append(" = ");
        $this$areOfflineMessagesExists_u24lambda_u241.append("messages.dialogId");
        String string2 = stringArray.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String joinColumn = string2;
        Object $this$areOfflineMessagesExists_u24lambda_u242 = $this$areOfflineMessagesExists_u24lambda_u241 = new StringBuilder();
        boolean bl2 = false;
        $this$areOfflineMessagesExists_u24lambda_u242.append("messages.dialogId = ? ");
        $this$areOfflineMessagesExists_u24lambda_u242.append("AND messages.serverSequence != ? ");
        $this$areOfflineMessagesExists_u24lambda_u242.append("AND messages.serverSequence != ? ");
        $this$areOfflineMessagesExists_u24lambda_u242.append("AND messages.status = ? ");
        $this$areOfflineMessagesExists_u24lambda_u242.append("AND dialogs.brand_id = ?");
        String string3 = $this$areOfflineMessagesExists_u24lambda_u241.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        String whereClause = string3;
        $this$areOfflineMessagesExists_u24lambda_u242 = new String[]{"OFFLINE_DIALOG", "-4", "-5", String.valueOf(MessagingChatMessage.MessageState.OFFLINE.ordinal()), brandId};
        String[] whereArgs = $this$areOfflineMessagesExists_u24lambda_u242;
        try {
            $this$areOfflineMessagesExists_u24lambda_u242 = (Closeable)this.getDB().query(joinColumn, null, whereClause, whereArgs, null, null, null, "1");
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)$this$areOfflineMessagesExists_u24lambda_u242;
                boolean bl3 = false;
                boolean bl4 = cursor.moveToFirst();
                return bl4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$areOfflineMessagesExists_u24lambda_u242, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            LPLog.INSTANCE.d(TAG, "areOfflineMessagesExists", (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOfflineWelcomeMessageExists(@NotNull String dialogId) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)dialogId, (String)"dialogId");
        Object $this$isOfflineWelcomeMessageExists_u24lambda_u244 = stringArray = new StringBuilder();
        boolean bl = false;
        $this$isOfflineWelcomeMessageExists_u24lambda_u244.append("(dialogId = ? OR dialogId = ? )");
        $this$isOfflineWelcomeMessageExists_u24lambda_u244.append(" AND ");
        $this$isOfflineWelcomeMessageExists_u24lambda_u244.append("(serverSequence = ? OR serverSequence = ? )");
        String string2 = stringArray.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String whereClause = string2;
        $this$isOfflineWelcomeMessageExists_u24lambda_u244 = new String[]{"KEY_WELCOME_DIALOG_ID", dialogId, "-4", "-5"};
        String[] whereArgs = $this$isOfflineWelcomeMessageExists_u24lambda_u244;
        try {
            $this$isOfflineWelcomeMessageExists_u24lambda_u244 = (Closeable)this.getDB().query(null, whereClause, whereArgs, null, null, null, "1");
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)$this$isOfflineWelcomeMessageExists_u24lambda_u244;
                boolean bl2 = false;
                boolean bl3 = cursor.moveToFirst();
                return bl3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$isOfflineWelcomeMessageExists_u24lambda_u244, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            LPLog.INSTANCE.d(TAG, "isOfflineWelcomeMessageExists", (Throwable)exception);
            return false;
        }
    }

    @Override
    public void updateOfflineMessagesDialogId(@NotNull String actualDialogId) {
        Intrinsics.checkNotNullParameter((Object)actualDialogId, (String)"actualDialogId");
        ContentValues contentValues = new ContentValues();
        contentValues.put("dialogId", actualDialogId);
        String whereClause = "dialogId =? ";
        String[] stringArray = new String[]{"OFFLINE_DIALOG"};
        String[] whereArgs = stringArray;
        int updatedRows = this.getDB().update(contentValues, whereClause, whereArgs);
        if (updatedRows > 0) {
            this.triggerUpdateMessagesForDialogId(actualDialogId);
        }
    }

    @Override
    public void removeOfflineWelcomeMessage() {
        String eventId = "KEY_WELCOME_DIALOG_ID-wm";
        String whereClause = "timeStamp = ? AND serverSequence = ? AND eventId = ?";
        String[] stringArray = new String[]{"9223372036854775805", "-4", eventId};
        String[] whereArgs = stringArray;
        int result = this.getDB().removeAll(whereClause, whereArgs);
        if (result > 0) {
            this.offlineMessagesListener.removeMessageByEventId(eventId);
        }
    }

    @Override
    public void removePendingOfflineMessages(@NotNull String brandId) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Set<String> eventIds = this.getPendingOfflineMessages(brandId);
        if (!((Collection)eventIds).isEmpty()) {
            String whereClause = "eventId in (?)";
            String[] stringArray = new String[]{CollectionsUtilsKt.joinToSQLString((Collection)eventIds, ",")};
            String[] whereArgs = stringArray;
            this.getDB().removeAll(whereClause, whereArgs);
        }
        this.setPendingOfflineMessages(brandId, new HashSet());
    }

    @Override
    public void setPendingOfflineMessages(@NotNull String brandId, @NotNull Set<String> eventIds) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter(eventIds, (String)"eventIds");
        this.preferenceManager.setStringsSet(KEY_OFFLINE_MESSAGES_EVENTS, brandId, eventIds);
    }

    @Override
    @NotNull
    public Set<String> getPendingOfflineMessages(@NotNull String brandId) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Set set = this.preferenceManager.getStringSet(KEY_OFFLINE_MESSAGES_EVENTS, brandId, (Set)new HashSet());
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"preferenceManager.getStr\u2026shSet<String>()\n        )");
        return set;
    }

    @Override
    public void removePendingOfflineMessage(@NotNull String brandId, @NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Set pendingOfflineMessages = CollectionsKt.toMutableSet((Iterable)this.getPendingOfflineMessages(brandId));
        pendingOfflineMessages.remove(eventId);
        this.setPendingOfflineMessages(brandId, pendingOfflineMessages);
    }

    @Override
    public boolean isMessagePending(@NotNull String brandId, @NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Set<String> pendingOfflineMessages = this.getPendingOfflineMessages(brandId);
        return pendingOfflineMessages.contains(eventId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerUpdateMessagesForDialogId(@NotNull String dialogId) {
        Intrinsics.checkNotNullParameter((Object)dialogId, (String)"dialogId");
        Object object = new String[]{"MIN(timeStamp)", "MAX(timeStamp)"};
        String[] stringArray = object;
        object = new String[]{dialogId};
        Cursor cursor = this.getDB().query(stringArray, "dialogId = ?", object, null, null, null);
        if (cursor != null) {
            object = (Closeable)cursor;
            Throwable throwable = null;
            try {
                Cursor cursor2 = (Cursor)object;
                boolean bl = false;
                if (cursor2.moveToFirst()) {
                    long firstMessageTimestampForConversation = cursor2.getLong(0);
                    long lastMessageTimestampForConversation = cursor2.getLong(1);
                    this.offlineMessagesListener.onUpdateMessages(firstMessageTimestampForConversation, lastMessageTimestampForConversation);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
    }

    private final String[] getPendingMessagesQueryParams(String brandId, String rowIds, String state) {
        String[] stringArray;
        if (!TextUtils.isEmpty((CharSequence)rowIds)) {
            String[] stringArray2 = new String[]{brandId, state, rowIds};
            stringArray = stringArray2;
        } else {
            String[] stringArray3 = new String[]{brandId, state};
            stringArray = stringArray3;
        }
        return stringArray;
    }

    private final String getPendingMessagesQuery(String rowIds) {
        StringBuilder whereBuilder = new StringBuilder().append("_id").append(" in (select m.").append("_id").append(" from ").append("messages").append(" m , ").append("dialogs").append(" c ").append("where (").append("m.").append("status").append("=").append(MessagingChatMessage.MessageState.OFFLINE.ordinal()).append(") and c.").append("brand_id").append("=?").append(" and c.").append("state").append("=?").append(" and m.").append("dialogId").append("= c.").append("dialog_id");
        if (!TextUtils.isEmpty((CharSequence)rowIds)) {
            LPLog.INSTANCE.d(TAG, "resendAllPendingMessages: There is upload images in progress, ignore these messages rowId: " + rowIds);
            whereBuilder.append(" and m.").append("_id").append(" not in (?)");
        }
        whereBuilder.append(")");
        String string2 = whereBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"whereBuilder.toString()");
        String where = string2;
        LPLog.INSTANCE.d(TAG, "getPendingMessagesQuery: where clause: " + where);
        return where;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/liveperson/messaging/offline/OfflineMessagesRepositoryImpl$Companion;", "", "()V", "KEY_OFFLINE_MESSAGES_EVENTS", "", "TAG", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lcom/liveperson/messaging/offline/OfflineMessagesRepositoryImpl$OfflineMessagesListener;", "", "onUpdateMessages", "", "firstTimestamp", "", "lastTimestamp", "removeMessageByEventId", "eventId", "", "messaging_release"})
    public static interface OfflineMessagesListener {
        public void onUpdateMessages(long var1, long var3);

        public void removeMessageByEventId(@NotNull String var1);
    }
}

