package com.liveperson.messaging.background.filesharing.voice;

import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.ReUploadFileTaskBundle;
import com.liveperson.messaging.commands.ReSendVoiceCommand;
import com.liveperson.messaging.exception.FileSharingException;

public class ReUploadVoiceTask extends UploadVoiceTask {

	public ReUploadVoiceTask(ReUploadFileTaskBundle params, Integer uploadTimeout) throws FileSharingException {

		super(params, uploadTimeout);

		mFileRowId = params.getFileRowId();

	}

	protected void createSendMessageCommand(String thumbnailPath, String filePath)  {

		sendMessageCommand = new ReSendVoiceCommand(MessagingFactory.getInstance().getController(),
				uploadFileTaskBundle.getTargetId(),
				uploadFileTaskBundle.getBrandId(),
				uploadFileTaskBundle.getFileContentType(),
				thumbnailPath,
				filePath,
				uploadFileTaskBundle.getFileTypeExtension(),
				uploadFileTaskBundle.getMessage(),
				((ReUploadFileTaskBundle) uploadFileTaskBundle).getFileRowId(),
                previewContentType,
				((ReUploadFileTaskBundle) uploadFileTaskBundle).getEventId());

		setSendMessageCommandCallback();
	}

}
