package com.liveperson.messaging.commands.tasks

import com.liveperson.api.response.model.DialogData
import com.liveperson.api.response.types.DialogType
import com.liveperson.messaging.Messaging
import com.liveperson.messaging.background.CoBrowseManager
import com.liveperson.messaging.commands.BasicQueryMessagesCommand
import com.liveperson.messaging.model.ConversationData
import com.liveperson.messaging.model.Dialog

class QueryCobrowseDialogStateCommand(
    controller: Messaging,
    brandId: String,
    private val conversationData: ConversationData,
    private val cobrowseDialog: Dialog,
    updateUi: Boolean,
): BasicQueryMessagesCommand(controller, brandId, conversationData.conversationId, cobrowseDialog.dialogId, updateUi) {
    override fun execute() {
        val mainDialog = conversationData.mainDialog
        val currentDialog = conversationData.findDialogById(cobrowseDialog.dialogId)
        if (mainDialog != null && currentDialog?.metaData == null) {
            CoBrowseManager.instance.saveHistoricalCobrowseDialog(
                controller,
                cobrowseDialog,
                mainDialog,
                mUpdateUI
            )
        }
        controller.amsDialogs.updateSequenceForCobrowseDialog(cobrowseDialog, 0)
        mResponseCallBack?.onTaskSuccess()
    }

    private fun ConversationData.findDialogById(id: String): DialogData? {
        return dialogs.find { it.dialogId == id }
    }

    private val ConversationData.mainDialog: DialogData?
        get() = dialogs.find { it.dialogType == DialogType.MAIN }
}