/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.request;

import android.text.TextUtils;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.GeneratedUploadTokenField;
import com.liveperson.api.request.ReqBody;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.network.socket.requests.NewConversationRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class GenerateUploadTokenRequest
extends BaseAMSSocketRequest<GeneratedUploadTokenField.Response, GenerateUploadTokenRequest> {
    private static final String TAG = "GenerateUploadTokenRequest";
    private String mDialogId;
    private String mFormId;
    private String mInvitationId;
    private ICallback<Object, Throwable> mCallback;

    public GenerateUploadTokenRequest(String socketUrl, String dialogId, String formId, String invitationId) {
        super(socketUrl);
        this.mDialogId = dialogId;
        this.mFormId = formId;
        this.mInvitationId = invitationId;
    }

    protected String getData() {
        return new GeneratedUploadTokenField(this.mDialogId, this.mFormId, this.mInvitationId).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    public void setResponseCallBack(ICallback<Object, Throwable> callBack) {
        this.mCallback = callBack;
    }

    protected BaseResponseHandler<GeneratedUploadTokenField.Response, GenerateUploadTokenRequest> getResponseHandler() {
        return new BaseResponseHandler<GeneratedUploadTokenField.Response, GenerateUploadTokenRequest>(){

            public String getAPIResponseType() {
                return GeneratedUploadTokenField.Response.GENERATE_UPLOAD_RESPONSE_TYPE;
            }

            public BaseResponseHandler getResponseByExpectedType(String expectedType) {
                BaseResponseHandler supportedResponseHandler = this.getSupportedResponseHandler(expectedType);
                if (supportedResponseHandler != null) {
                    return supportedResponseHandler;
                }
                return this;
            }

            protected BaseResponseHandler getSupportedResponseHandler(String messageType) {
                if (TextUtils.equals((CharSequence)messageType, (CharSequence)"StringResponse")) {
                    return new BaseResponseHandler<ReqBody.StringResp, NewConversationRequest>(){

                        public String getAPIResponseType() {
                            return "StringResponse";
                        }

                        protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                            return new ReqBody.StringResp(jsonObject);
                        }

                        protected boolean handle(ReqBody.StringResp response) {
                            LPLog.INSTANCE.d(GenerateUploadTokenRequest.TAG, "Received String response (" + response.code + ").");
                            if (response.code > 201) {
                                LPLog.INSTANCE.w(GenerateUploadTokenRequest.TAG, "Received bad response (" + response.code + ").");
                                GenerateUploadTokenRequest.this.mCallback.onError((Throwable)new Exception());
                                return true;
                            }
                            return false;
                        }
                    };
                }
                return super.getSupportedResponseHandler(messageType);
            }

            protected GeneratedUploadTokenField.Response parse(JSONObject jsonObject) throws JSONException {
                LPLog.INSTANCE.d(GenerateUploadTokenRequest.TAG, "Got resolve response: " + jsonObject.optString("code"));
                if (jsonObject.optString("code").equalsIgnoreCase("200")) {
                    return new GeneratedUploadTokenField.Response(jsonObject);
                }
                return null;
            }

            protected boolean handle(GeneratedUploadTokenField.Response data) {
                LPLog.INSTANCE.d(GenerateUploadTokenRequest.TAG, "Got resolve response: " + LPLog.INSTANCE.mask((Object)data.getBody()));
                GenerateUploadTokenRequest.this.mCallback.onSuccess((Object)data.getBody());
                return true;
            }

            protected void giveUp() {
                super.giveUp();
                LPLog.INSTANCE.d(GenerateUploadTokenRequest.TAG, "Giving up - socket closed");
                GenerateUploadTokenRequest.this.mCallback.onError((Throwable)new Exception());
            }
        };
    }
}

