/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.database.Cursor;
import android.os.Bundle;
import android.text.TextUtils;
import com.liveperson.infra.database.tables.FilesTable;
import java.util.Objects;

public class FileMessage {
    public static final String EXTRA_LOCAL_URL = "EXTRA_LOCAL_URL";
    public static final String EXTRA_PREVIEW = "EXTRA_PREVIEW";
    public static final String EXTRA_LOAD_STATUS = "EXTRA_LOAD_STATUS";
    public static final String EXTRA_FULL_IMAGE_EXISTS = "EXTRA_FULL_IMAGE_EXISTS";
    public static final String EXTRA_PREVIEW_IMAGE_EXISTS = "EXTRA_PREVIEW_IMAGE_EXISTS";
    public static final String EXTRA_FILE_ROW_ID = "EXTRA_FILE_ROW_ID";
    public static final String EXTRA_FILE_TYPE = "EXTRA_FILE_TYPE";
    private long mFileRowId;
    private String mPreview;
    private String mSwiftPath;
    private String mFileType;
    private String mLocalUrl;
    private long mRelatedMessageRowID;
    private FilesTable.LoadStatus mLoadStatus;

    public FileMessage(String preview, String fileType, String localUrl, String swiftPath, long relatedMessageRowID) {
        this.mPreview = preview;
        this.mFileType = fileType;
        this.mLocalUrl = localUrl;
        this.mLoadStatus = FilesTable.LoadStatus.NOT_STARTED;
        this.mRelatedMessageRowID = relatedMessageRowID;
        this.mSwiftPath = swiftPath;
    }

    public FileMessage(FileMessage delegated, long localFileRowId) {
        this(delegated.getPreview(), delegated.getFileType(), delegated.getLocalUrl(), delegated.getSwiftPath(), delegated.getRelatedMessageRowID());
        this.mFileRowId = localFileRowId;
    }

    private FileMessage(Cursor cursor) {
        int columnIndex = cursor.getColumnIndex("file_row_id");
        this.mFileRowId = columnIndex != -1 ? cursor.getLong(columnIndex) : cursor.getLong(cursor.getColumnIndex("_id"));
        this.mRelatedMessageRowID = cursor.getInt(cursor.getColumnIndex("relatedMessageRowID"));
        this.mPreview = cursor.getString(cursor.getColumnIndex("preview"));
        this.mFileType = cursor.getString(cursor.getColumnIndex("fileType"));
        this.mLocalUrl = cursor.getString(cursor.getColumnIndex("localUrl"));
        this.mLoadStatus = FilesTable.LoadStatus.values()[cursor.getInt(cursor.getColumnIndex("loadStatus"))];
        this.mSwiftPath = cursor.getString(cursor.getColumnIndex("swiftPath"));
    }

    public static FileMessage fromCursor(Cursor cursor) {
        if (cursor == null) {
            return null;
        }
        int relatedMessageRowIDColumn = cursor.getColumnIndex("relatedMessageRowID");
        if (relatedMessageRowIDColumn == -1) {
            return null;
        }
        return new FileMessage(cursor);
    }

    public String getPreview() {
        return this.mPreview;
    }

    public String getSwiftPath() {
        return this.mSwiftPath;
    }

    public String getFileType() {
        return this.mFileType;
    }

    public String getLocalUrl() {
        return this.mLocalUrl;
    }

    public long getFileRowId() {
        return this.mFileRowId;
    }

    public long getRelatedMessageRowID() {
        return this.mRelatedMessageRowID;
    }

    public FilesTable.LoadStatus getLoadStatus() {
        return this.mLoadStatus;
    }

    public Bundle update(FileMessage newFileMessage) {
        Bundle extras = new Bundle();
        if (newFileMessage != null) {
            if (this.mFileRowId != newFileMessage.getFileRowId()) {
                this.mFileRowId = newFileMessage.getFileRowId();
                extras.putLong(EXTRA_FILE_ROW_ID, this.mFileRowId);
            }
            boolean imageChanges = false;
            if (!TextUtils.equals((CharSequence)this.mPreview, (CharSequence)newFileMessage.getPreview())) {
                this.mPreview = newFileMessage.getPreview();
                imageChanges = true;
            }
            extras.putString(EXTRA_PREVIEW, this.mPreview);
            if (!TextUtils.equals((CharSequence)this.mLocalUrl, (CharSequence)newFileMessage.getLocalUrl())) {
                this.mLocalUrl = newFileMessage.getLocalUrl();
                imageChanges = true;
            }
            extras.putString(EXTRA_LOCAL_URL, this.mLocalUrl);
            if (this.mLoadStatus != newFileMessage.getLoadStatus()) {
                this.mLoadStatus = newFileMessage.getLoadStatus();
                extras.putInt(EXTRA_LOAD_STATUS, this.mLoadStatus.ordinal());
            }
            if (!TextUtils.equals((CharSequence)this.mSwiftPath, (CharSequence)newFileMessage.getSwiftPath())) {
                this.mSwiftPath = newFileMessage.getSwiftPath();
            }
            if (this.mFileType != null) {
                extras.putString(EXTRA_FILE_TYPE, this.mFileType);
            }
            if (!extras.isEmpty() && !imageChanges) {
                if (!TextUtils.isEmpty((CharSequence)this.mLocalUrl)) {
                    extras.putBoolean(EXTRA_FULL_IMAGE_EXISTS, true);
                } else if (!TextUtils.isEmpty((CharSequence)this.mPreview)) {
                    extras.putBoolean(EXTRA_PREVIEW_IMAGE_EXISTS, true);
                }
            }
        }
        return extras;
    }

    public Bundle getAllFileChanges() {
        Bundle extras = new Bundle();
        extras.putString(EXTRA_PREVIEW, this.mPreview);
        extras.putString(EXTRA_LOCAL_URL, this.mLocalUrl);
        extras.putLong(EXTRA_FILE_ROW_ID, this.mFileRowId);
        if (!TextUtils.isEmpty((CharSequence)this.mLocalUrl)) {
            extras.putBoolean(EXTRA_FULL_IMAGE_EXISTS, true);
        } else if (!TextUtils.isEmpty((CharSequence)this.mPreview)) {
            extras.putBoolean(EXTRA_PREVIEW_IMAGE_EXISTS, true);
        }
        extras.putInt(EXTRA_LOAD_STATUS, this.mLoadStatus.ordinal());
        return extras;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileMessage that = (FileMessage)o;
        return this.mFileRowId == that.mFileRowId && this.mRelatedMessageRowID == that.mRelatedMessageRowID && Objects.equals(this.mPreview, that.mPreview) && Objects.equals(this.mSwiftPath, that.mSwiftPath) && Objects.equals(this.mFileType, that.mFileType) && Objects.equals(this.mLocalUrl, that.mLocalUrl) && this.mLoadStatus == that.mLoadStatus;
    }

    public int hashCode() {
        return Objects.hash(this.mFileRowId, this.mPreview, this.mSwiftPath, this.mFileType, this.mLocalUrl, this.mRelatedMessageRowID, this.mLoadStatus);
    }
}

