/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.wm;

import android.content.Context;
import android.content.SharedPreferences;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.model.LPWelcomeMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.wm.WelcomeMessageBroadcastReceiver;
import com.liveperson.messaging.wm.WelcomeMessageManager;
import com.liveperson.messaging.wm.WelcomeMessageStoreUtilsKt;
import com.liveperson.monitoring.MonitoringFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB?\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0013\u001a\u00020\u0007J\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0006R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/liveperson/messaging/wm/WelcomeMessageManager;", "", "sharedPreferences", "Landroid/content/SharedPreferences;", "responseSender", "Lkotlin/Function1;", "", "", "defaultWelcomeMessageProvider", "Lkotlin/Function0;", "Lcom/liveperson/infra/model/LPWelcomeMessage;", "timeOutProvider", "", "(Landroid/content/SharedPreferences;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "pendingRequests", "", "Ljava/util/concurrent/ScheduledFuture;", "requestsExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "cancelTimeoutTasks", "clearWelcomeMessage", "dispose", "getWelcomeMessage", "brandId", "getWelcomeMessageFrequency", "Lcom/liveperson/infra/model/LPWelcomeMessage$MessageFrequency;", "requestNewWelcomeMessage", "Companion", "NotifierTask", "messaging_release"})
@SourceDebugExtension(value={"SMAP\nWelcomeMessageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WelcomeMessageManager.kt\ncom/liveperson/messaging/wm/WelcomeMessageManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n1855#2,2:246\n1#3:248\n*S KotlinDebug\n*F\n+ 1 WelcomeMessageManager.kt\ncom/liveperson/messaging/wm/WelcomeMessageManager\n*L\n171#1:246,2\n*E\n"})
public final class WelcomeMessageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedPreferences sharedPreferences;
    @NotNull
    private final Function1<String, Unit> responseSender;
    @NotNull
    private final Function0<LPWelcomeMessage> defaultWelcomeMessageProvider;
    @NotNull
    private final Function0<Long> timeOutProvider;
    @NotNull
    private final ScheduledExecutorService requestsExecutor;
    @NotNull
    private final List<ScheduledFuture<?>> pendingRequests;
    @NotNull
    private static final String KEY_DYNAMIC_WELCOME_MESSAGE = "welcome.message";
    @NotNull
    private static final String KEY_DYNAMIC_WELCOME_MESSAGE_FREQUENCY = "welcome.message.frequency";
    @NotNull
    private static final String JSON_KEY_WELCOME_MESSAGE_CONTENT = "content";
    @NotNull
    private static final String JSON_KEY_WELCOME_MESSAGE_ACTIONS = "actions";
    @NotNull
    private static final String JSON_KEY_WELCOME_MESSAGE_FREQUENCY = "frequency";

    private WelcomeMessageManager(SharedPreferences sharedPreferences, Function1<? super String, Unit> responseSender, Function0<LPWelcomeMessage> defaultWelcomeMessageProvider, Function0<Long> timeOutProvider) {
        this.sharedPreferences = sharedPreferences;
        this.responseSender = responseSender;
        this.defaultWelcomeMessageProvider = defaultWelcomeMessageProvider;
        this.timeOutProvider = timeOutProvider;
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor()");
        this.requestsExecutor = scheduledExecutorService;
        this.pendingRequests = new ArrayList();
    }

    public final synchronized void requestNewWelcomeMessage(@NotNull String brandId) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        long delay = ((Number)this.timeOutProvider.invoke()).longValue();
        NotifierTask task = new NotifierTask(brandId, this.responseSender);
        if (delay <= 0L) {
            this.requestsExecutor.execute(task);
        } else {
            ScheduledFuture<?> scheduledFuture = this.requestsExecutor.schedule(task, delay, TimeUnit.SECONDS);
            Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"requestsExecutor.schedul\u2026 delay, TimeUnit.SECONDS)");
            this.pendingRequests.add(scheduledFuture);
        }
    }

    public final synchronized void cancelTimeoutTasks() {
        Iterable $this$forEach$iv = this.pendingRequests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScheduledFuture it = (ScheduledFuture)element$iv;
            boolean bl = false;
            if (it.isCancelled() || it.isDone()) continue;
            it.cancel(true);
        }
        this.pendingRequests.clear();
    }

    public final void clearWelcomeMessage() {
        this.sharedPreferences.edit().clear().commit();
    }

    @NotNull
    public final LPWelcomeMessage.MessageFrequency getWelcomeMessageFrequency(@NotNull String brandId) {
        LPWelcomeMessage.MessageFrequency messageFrequency;
        LPWelcomeMessage ccuiWM;
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        if (MonitoringFactory.INSTANCE.getMonitoring().getInitialized() && MonitoringFactory.INSTANCE.getMonitoring().getWelcomeMessageMap().containsKey(brandId) && (ccuiWM = (LPWelcomeMessage)MonitoringFactory.INSTANCE.getMonitoring().getWelcomeMessageMap().get(brandId)) != null) {
            LPWelcomeMessage.MessageFrequency messageFrequency2 = ccuiWM.getMessageFrequency();
            Intrinsics.checkNotNullExpressionValue((Object)messageFrequency2, (String)"ccuiWM.messageFrequency");
            return messageFrequency2;
        }
        LPWelcomeMessage message = (LPWelcomeMessage)this.defaultWelcomeMessageProvider.invoke();
        int frequency = this.sharedPreferences.getInt(KEY_DYNAMIC_WELCOME_MESSAGE_FREQUENCY + brandId, -1);
        boolean bl = 0 <= frequency ? frequency < 2 : false;
        if (bl) {
            LPWelcomeMessage.MessageFrequency messageFrequency3 = LPWelcomeMessage.MessageFrequency.fromOrdinal((int)frequency);
            messageFrequency = messageFrequency3;
            Intrinsics.checkNotNullExpressionValue((Object)messageFrequency3, (String)"{\n            MessageFre\u2026inal(frequency)\n        }");
        } else {
            LPWelcomeMessage.MessageFrequency messageFrequency4 = message.getMessageFrequency();
            messageFrequency = messageFrequency4;
            Intrinsics.checkNotNullExpressionValue((Object)messageFrequency4, (String)"{\n            message.messageFrequency\n        }");
        }
        return messageFrequency;
    }

    @NotNull
    public final LPWelcomeMessage getWelcomeMessage(@NotNull String brandId) {
        Object object;
        LPWelcomeMessage ccuiWM;
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        if (MonitoringFactory.INSTANCE.getMonitoring().getInitialized() && MonitoringFactory.INSTANCE.getMonitoring().getWelcomeMessageMap().containsKey(brandId) && (ccuiWM = (LPWelcomeMessage)MonitoringFactory.INSTANCE.getMonitoring().getWelcomeMessageMap().get(brandId)) != null) {
            return ccuiWM;
        }
        String content = this.sharedPreferences.getString(KEY_DYNAMIC_WELCOME_MESSAGE + brandId, "");
        CharSequence charSequence = content;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            LPWelcomeMessage welcomeMessage;
            LPWelcomeMessage lPWelcomeMessage;
            LPWelcomeMessage it = lPWelcomeMessage = (welcomeMessage = WelcomeMessageManager.Companion.createWelcomeMessageFromJson(content));
            boolean bl = false;
            CharSequence charSequence2 = it.getWelcomeMessage();
            object = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? lPWelcomeMessage : null;
            if (object == null) {
                object = (LPWelcomeMessage)this.defaultWelcomeMessageProvider.invoke();
            }
        } else {
            object = (LPWelcomeMessage)this.defaultWelcomeMessageProvider.invoke();
        }
        return object;
    }

    public final void dispose() {
        this.requestsExecutor.shutdown();
    }

    @JvmStatic
    @NotNull
    public static final WelcomeMessageManager newInstance(@NotNull Messaging messaging) {
        return Companion.newInstance(messaging);
    }

    @JvmStatic
    public static final void setWelcomeMessage(@NotNull Context context, @NotNull String brandId, @Nullable LPWelcomeMessage welcomeMessage) {
        Companion.setWelcomeMessage(context, brandId, welcomeMessage);
    }

    @JvmStatic
    @Nullable
    public static final LPWelcomeMessage getWelcomeMessage(@NotNull Context context, @NotNull String brandId) {
        return Companion.getWelcomeMessage(context, brandId);
    }

    public /* synthetic */ WelcomeMessageManager(SharedPreferences sharedPreferences, Function1 responseSender, Function0 defaultWelcomeMessageProvider, Function0 timeOutProvider, DefaultConstructorMarker $constructor_marker) {
        this(sharedPreferences, (Function1<? super String, Unit>)responseSender, (Function0<LPWelcomeMessage>)defaultWelcomeMessageProvider, (Function0<Long>)timeOutProvider);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0007J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0007J\u001c\u0010\u0017\u001a\u00020\u0018*\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/liveperson/messaging/wm/WelcomeMessageManager$Companion;", "", "()V", "JSON_KEY_WELCOME_MESSAGE_ACTIONS", "", "JSON_KEY_WELCOME_MESSAGE_CONTENT", "JSON_KEY_WELCOME_MESSAGE_FREQUENCY", "KEY_DYNAMIC_WELCOME_MESSAGE", "KEY_DYNAMIC_WELCOME_MESSAGE_FREQUENCY", "defaultWelcomeMessage", "Lcom/liveperson/infra/model/LPWelcomeMessage;", "Lcom/liveperson/messaging/Messaging;", "getDefaultWelcomeMessage", "(Lcom/liveperson/messaging/Messaging;)Lcom/liveperson/infra/model/LPWelcomeMessage;", "createWelcomeMessageFromJson", "content", "getWelcomeMessage", "context", "Landroid/content/Context;", "brandId", "newInstance", "Lcom/liveperson/messaging/wm/WelcomeMessageManager;", "messaging", "setWelcomeMessage", "", "welcomeMessage", "Landroid/content/SharedPreferences;", "messaging_release"})
    @SourceDebugExtension(value={"SMAP\nWelcomeMessageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WelcomeMessageManager.kt\ncom/liveperson/messaging/wm/WelcomeMessageManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n1#2:246\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final LPWelcomeMessage getDefaultWelcomeMessage(Messaging $this$defaultWelcomeMessage) {
            LPWelcomeMessage lPWelcomeMessage;
            LPWelcomeMessage message = $this$defaultWelcomeMessage.getConversationViewParams().getLpWelcomeMessage();
            CharSequence charSequence = message.getWelcomeMessage();
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                LPWelcomeMessage lPWelcomeMessage2 = message;
                lPWelcomeMessage = lPWelcomeMessage2;
                Intrinsics.checkNotNullExpressionValue((Object)lPWelcomeMessage2, (String)"{\n                    message\n                }");
            } else {
                lPWelcomeMessage = new LPWelcomeMessage($this$defaultWelcomeMessage.getApplicationContext().getString(R.string.lp_first_message));
            }
            return lPWelcomeMessage;
        }

        private final void setWelcomeMessage(SharedPreferences $this$setWelcomeMessage, String brandId, LPWelcomeMessage welcomeMessage) {
            JSONObject json = new JSONObject();
            json.put(WelcomeMessageManager.JSON_KEY_WELCOME_MESSAGE_CONTENT, (Object)welcomeMessage.getWelcomeMessage());
            List list = welcomeMessage.getMessageOptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"welcomeMessage.messageOptions");
            json.put(WelcomeMessageManager.JSON_KEY_WELCOME_MESSAGE_ACTIONS, (Object)WelcomeMessageStoreUtilsKt.serialize(list));
            json.put(WelcomeMessageManager.JSON_KEY_WELCOME_MESSAGE_FREQUENCY, welcomeMessage.getMessageFrequency().ordinal());
            $this$setWelcomeMessage.edit().putString(WelcomeMessageManager.KEY_DYNAMIC_WELCOME_MESSAGE + brandId, json.toString()).putInt(WelcomeMessageManager.KEY_DYNAMIC_WELCOME_MESSAGE_FREQUENCY + brandId, welcomeMessage.getMessageFrequency().ordinal()).commit();
        }

        private final LPWelcomeMessage createWelcomeMessageFromJson(String content) {
            Object object;
            LPWelcomeMessage $this$createWelcomeMessageFromJson_u24lambda_u241_u24lambda_u240;
            LPWelcomeMessage lPWelcomeMessage;
            block3: {
                block2: {
                    JSONObject $this$createWelcomeMessageFromJson_u24lambda_u241 = new JSONObject(content);
                    boolean bl = false;
                    $this$createWelcomeMessageFromJson_u24lambda_u241_u24lambda_u240 = lPWelcomeMessage = new LPWelcomeMessage($this$createWelcomeMessageFromJson_u24lambda_u241.optString(WelcomeMessageManager.JSON_KEY_WELCOME_MESSAGE_CONTENT));
                    boolean bl2 = false;
                    int frequency = $this$createWelcomeMessageFromJson_u24lambda_u241.optInt(WelcomeMessageManager.JSON_KEY_WELCOME_MESSAGE_FREQUENCY, LPWelcomeMessage.MessageFrequency.FIRST_TIME_CONVERSATION.ordinal());
                    $this$createWelcomeMessageFromJson_u24lambda_u241_u24lambda_u240.setMessageFrequency(LPWelcomeMessage.MessageFrequency.fromOrdinal((int)frequency));
                    JSONArray jSONArray = $this$createWelcomeMessageFromJson_u24lambda_u241.optJSONArray(WelcomeMessageManager.JSON_KEY_WELCOME_MESSAGE_ACTIONS);
                    object = jSONArray;
                    if (object == null) break block2;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"optJSONArray(JSON_KEY_WELCOME_MESSAGE_ACTIONS)");
                    object = WelcomeMessageStoreUtilsKt.toMessageOptions(jSONArray);
                    if (object != null) break block3;
                }
                object = CollectionsKt.emptyList();
            }
            $this$createWelcomeMessageFromJson_u24lambda_u241_u24lambda_u240.setMessageOptions((List)object);
            LPWelcomeMessage welcomeMessage = lPWelcomeMessage;
            return welcomeMessage;
        }

        @JvmStatic
        @NotNull
        public final WelcomeMessageManager newInstance(@NotNull Messaging messaging) {
            Intrinsics.checkNotNullParameter((Object)messaging, (String)"messaging");
            Context context = messaging.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            return new WelcomeMessageManager(WelcomeMessageStoreUtilsKt.getWelcomeMessagePreferences(context), (Function1)new Function1<String, Unit>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(1);
                }

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Context context = this.$context;
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    WelcomeMessageBroadcastReceiver.Companion.sendWelcomeMessageEvent$messaging_release$default(WelcomeMessageBroadcastReceiver.Companion, context, "welcome.message.response" + it, null, 2, null);
                }
            }, (Function0)new Function0<LPWelcomeMessage>(messaging){
                final /* synthetic */ Messaging $messaging;
                {
                    this.$messaging = $messaging;
                    super(0);
                }

                @NotNull
                public final LPWelcomeMessage invoke() {
                    return com.liveperson.messaging.wm.WelcomeMessageManager$Companion.access$getDefaultWelcomeMessage(WelcomeMessageManager.Companion, this.$messaging);
                }
            }, newInstance.3.INSTANCE, null);
        }

        @JvmStatic
        public final void setWelcomeMessage(@NotNull Context context, @NotNull String brandId, @Nullable LPWelcomeMessage welcomeMessage) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            SharedPreferences preferences = WelcomeMessageStoreUtilsKt.getWelcomeMessagePreferences(context2);
            if (welcomeMessage == null) {
                preferences.edit().clear().commit();
            } else {
                this.setWelcomeMessage(preferences, brandId, welcomeMessage);
            }
        }

        @JvmStatic
        @Nullable
        public final LPWelcomeMessage getWelcomeMessage(@NotNull Context context, @NotNull String brandId) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            SharedPreferences preferences = WelcomeMessageStoreUtilsKt.getWelcomeMessagePreferences(context2);
            String it = string2 = preferences.getString(WelcomeMessageManager.KEY_DYNAMIC_WELCOME_MESSAGE + brandId, "");
            boolean bl = false;
            CharSequence charSequence = it;
            String string3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
            if (string3 == null) {
                return null;
            }
            String content = string3;
            return this.createWelcomeMessageFromJson(content);
        }

        public static final /* synthetic */ LPWelcomeMessage access$getDefaultWelcomeMessage(Companion $this, Messaging $receiver) {
            return $this.getDefaultWelcomeMessage($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/liveperson/messaging/wm/WelcomeMessageManager$NotifierTask;", "Ljava/lang/Runnable;", "brandId", "", "intentSender", "Lkotlin/Function1;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "run", "messaging_release"})
    private static final class NotifierTask
    implements Runnable {
        @NotNull
        private final String brandId;
        @NotNull
        private final Function1<String, Unit> intentSender;

        public NotifierTask(@NotNull String brandId, @NotNull Function1<? super String, Unit> intentSender) {
            Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
            Intrinsics.checkNotNullParameter(intentSender, (String)"intentSender");
            this.brandId = brandId;
            this.intentSender = intentSender;
        }

        @Override
        public void run() {
            this.intentSender.invoke((Object)this.brandId);
        }
    }
}

