@file:JvmName("SDKLinkUtils")
package com.liveperson.messaging.utils

import com.liveperson.infra.configuration.Configuration
import com.liveperson.infra.messaging.R
import com.liveperson.infra.utils.patterns.PatternsCompat
import java.util.regex.PatternSyntaxException

fun containsLink(text: String): Boolean {
    return findFirstWebLink(text) != null
}

fun findFirstWebLink(text: String): String? {
    val brandRegex = Configuration.getString(R.string.lp_bubble_url_links_regex)
    val resultRegex: Regex = when {
        brandRegex.isNullOrBlank() -> {
            PatternsCompat.AUTOLINK_WEB_URL.toRegex()
        }
        else -> try {
            Regex(brandRegex)
        } catch (exception: PatternSyntaxException) {
            PatternsCompat.AUTOLINK_WEB_URL.toRegex()
        }
    }
    return resultRegex.find(text)?.value
}