package com.liveperson.messaging.wm.core

/**
 * Component used to receive values from multi-process
 * shared preferences.
 */
interface ValueReader {

    /**
     * Method used to read a value from shared preferences.
     *
     * @param key identifier of value in shared preferences
     * @param default default value if requested preferences
     * wasn't previously stored.
     *
     * @return value stored in preferences by key or default value
     * by default.
     */
    fun <T: Any?> readValue(key: String, default: T): T

    /**
     * Method used to read all stored values in shared preferences.
     *
     * @return mutable map of all stored values and their associated keys.
     */
    fun getAllValues(): MutableMap<String, *>

    /**
     * Method used to check whether value by request key presented
     * in shared preferences.
     *
     * @return true if shared preference contains value
     * for associated key or false otherwise.
     */
    fun containsValue(key: String): Boolean
}