/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.SendImageCommand;
import com.liveperson.messaging.model.MessagingChatMessage;

public class ReSendImageCommand
extends SendImageCommand {
    private long mFileRowId;

    public ReSendImageCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String imagePath, String fileExtension, String eventId, MaskedMessage message, long fileRowId) {
        super(controller, targetId, brandId, contentType, thumbnailPath, imagePath, fileExtension, message);
        this.mFileRowId = fileRowId;
        this.mEventId = eventId;
    }

    @Override
    protected void addMessageToDBAndSend(String conversationId, MaskedMessage message, MessagingChatMessage.MessageState state) {
        this.mController.amsMessages.updateMessageState(this.mEventId, MessagingChatMessage.MessageState.QUEUED);
        this.mController.amsMessages.getRowIdByEventId(this.mEventId).setPostQueryOnBackground(data -> {
            this.mMessageRowId = data;
            if (this.mCallback != null) {
                this.mCallback.onFileAddedToDB(this.mMessageRowId, this.mFileRowId, false);
            }
        }).execute();
    }

    @Override
    protected boolean canSendWhileOffline() {
        return false;
    }
}

