/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.offline;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.ConversationUtils;
import com.liveperson.messaging.model.FileMessage;
import com.liveperson.messaging.model.FullMessageRow;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.network.socket.requests.NewConversationRequest;
import com.liveperson.messaging.offline.api.OfflineMessagesController;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u00060\u001dj\u0002`\u001e\u0018\u00010\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0010\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lcom/liveperson/messaging/offline/OfflineMessagesControllerImpl;", "Lcom/liveperson/messaging/offline/api/OfflineMessagesController;", "mMessaging", "Lcom/liveperson/messaging/Messaging;", "(Lcom/liveperson/messaging/Messaging;)V", "currentBrandId", "", "getCurrentBrandId", "()Ljava/lang/String;", "isFullySynced", "", "()Z", "setFullySynced", "(Z)V", "isOfflineModeEnabled", "isOfflineWelcomeMessageEnabled", "isSubscribedToActiveDialog", "setSubscribedToActiveDialog", "mConversationUtils", "Lcom/liveperson/messaging/model/ConversationUtils;", "offlineModePCSBehavior", "", "getOfflineModePCSBehavior", "()I", "resolveActiveDialog", "", "dialogId", "callback", "Lcom/liveperson/infra/ICallback;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "sendNewConversationRequest", "requestId", "", "sendOfflineMessage", "message", "Lcom/liveperson/messaging/model/FullMessageRow;", "messaging_release"})
public final class OfflineMessagesControllerImpl
implements OfflineMessagesController {
    @NotNull
    private final Messaging mMessaging;
    private volatile boolean isSubscribedToActiveDialog;
    private volatile boolean isFullySynced;
    @NotNull
    private final ConversationUtils mConversationUtils;

    public OfflineMessagesControllerImpl(@NotNull Messaging mMessaging) {
        Intrinsics.checkNotNullParameter((Object)mMessaging, (String)"mMessaging");
        this.mMessaging = mMessaging;
        this.mConversationUtils = new ConversationUtils(this.mMessaging);
    }

    @Override
    public boolean isSubscribedToActiveDialog() {
        return this.isSubscribedToActiveDialog;
    }

    @Override
    public void setSubscribedToActiveDialog(boolean bl) {
        this.isSubscribedToActiveDialog = bl;
    }

    @Override
    public boolean isFullySynced() {
        return this.isFullySynced;
    }

    @Override
    public void setFullySynced(boolean bl) {
        this.isFullySynced = bl;
    }

    @Override
    @NotNull
    public String getCurrentBrandId() {
        String string2 = this.mMessaging.getActiveBrandId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mMessaging.activeBrandId");
        return string2;
    }

    @Override
    public boolean isOfflineModeEnabled() {
        return Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled);
    }

    @Override
    public boolean isOfflineWelcomeMessageEnabled() {
        return Configuration.getBoolean((int)R.bool.lp_is_offline_welcome_message_enabled);
    }

    @Override
    public int getOfflineModePCSBehavior() {
        return Configuration.getInteger((int)R.integer.lp_offline_messages_for_pcs_behavior);
    }

    @Override
    public void resolveActiveDialog(@NotNull String dialogId, @Nullable ICallback<Integer, Exception> callback) {
        Intrinsics.checkNotNullParameter((Object)dialogId, (String)"dialogId");
        this.mMessaging.closeDialog(this.getCurrentBrandId(), dialogId, callback);
    }

    @Override
    public void sendNewConversationRequest(long requestId) {
        String brandId = this.getCurrentBrandId();
        NewConversationRequest newConversationRequest = new NewConversationRequest(this.mMessaging, brandId, brandId, "TEMP_CONVERSATION", "TEMP_DIALOG");
        newConversationRequest.setRequestId(requestId);
        this.mMessaging.amsConversations.enqueuePendingConversationRequestId(requestId);
        SocketManager.getInstance().send((BaseSocketRequest)newConversationRequest);
    }

    @Override
    public void sendOfflineMessage(@NotNull FullMessageRow message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MessagingChatMessage chatMessage = message.getMessagingChatMessage();
        FileMessage fileMessage = message.getFileMessage();
        if (fileMessage == null) {
            this.mMessaging.resendMessage(chatMessage.getEventId(), chatMessage.getDialogId(), chatMessage.getMessageType(), true);
        } else {
            this.mMessaging.resendMessage(chatMessage.getEventId(), chatMessage.getDialogId(), fileMessage.getFileRowId(), chatMessage.getMessageType(), true);
        }
    }
}

