/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import androidx.annotation.NonNull;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.SendMessageCommand;
import com.liveperson.messaging.model.Form;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.network.socket.requests.SendFormSubmissionMessageRequest;

public class SendFormSubmissionMessageCommand
extends SendMessageCommand {
    private String mSubmissionId;
    private String mInvitationId;

    public SendFormSubmissionMessageCommand(Form form, MaskedMessage message, Messaging controller) {
        super(controller, form.getSiteId(), form.getSiteId(), message);
        this.mBrandId = form.getSiteId();
        this.mTargetId = form.getSiteId();
        this.mMessage = message;
        this.mSubmissionId = form.getSubmissionId();
        this.mInvitationId = form.getInvitationId();
    }

    @Override
    @NonNull
    protected MessagingChatMessage createNewChatMessage(String dialogId, MaskedMessage message, MessagingChatMessage.MessageState state) {
        return new MessagingChatMessage(this.mConsumerId, message.getDbMessage(), System.currentTimeMillis(), dialogId, this.mEventId, MessagingChatMessage.MessageType.CONSUMER_FORM, state, EncryptionVersion.NONE);
    }

    @Override
    @NonNull
    protected SendFormSubmissionMessageRequest createMessageRequest(Messaging mController, String mEventId, String mTargetId, String mBrandId, String dialogId, String conversationId) {
        return new SendFormSubmissionMessageRequest(mController, mEventId, mTargetId, mBrandId, dialogId, conversationId, this.mInvitationId, this.mSubmissionId);
    }
}

