/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import android.text.TextUtils;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.infra.Command;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.model.SynchronizedAmsConnectionCallback;
import com.liveperson.messaging.model.UserProfile;
import com.liveperson.messaging.network.socket.requests.SetUsersProfileRequest;

public class SendSetUserProfileCommand
implements Command {
    private static final String TAG = "SendSetUserProfileCommand";
    private final Messaging mController;
    private String mBrandId;
    private UserProfile mUserProfile;

    public SendSetUserProfileCommand(Messaging messagingController, String brandId, UserProfile userProfile) {
        this.mController = messagingController;
        this.mBrandId = brandId;
        this.mUserProfile = userProfile;
    }

    public void execute() {
        LPLog.INSTANCE.i(TAG, "Running SetUserProfile request...");
        new SynchronizedAmsConnectionCallback(this.mController.mConnectionController, this.mBrandId, () -> {
            if (TextUtils.isEmpty((CharSequence)this.mBrandId)) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000E5, "execute: BrandId is empty. Cannot proceed with set user profile");
                return;
            }
            String consumerId = this.mController.amsUsers.getConsumerId(this.mBrandId);
            LPLog.INSTANCE.d(TAG, "Consumer id: " + LPLog.INSTANCE.mask((Object)(consumerId + "\n" + this.mUserProfile)));
            MessagingUserProfile msgUserProfile = new MessagingUserProfile(this.mUserProfile.getFirstName(), this.mUserProfile.getLastName(), UserProfile.UserType.CONSUMER);
            msgUserProfile.setAvatarUrl(this.mUserProfile.getAvatarUrl());
            msgUserProfile.setNickname(this.mUserProfile.getNickname());
            msgUserProfile.setDescription(this.mUserProfile.getPhoneNumber());
            msgUserProfile.setPrivateData(new UserProfile.PrivateData("", ""));
            msgUserProfile.setMobileNumber(this.mUserProfile.getPhoneNumber());
            msgUserProfile.setOriginatorID(consumerId);
            SetUsersProfileRequest setUsersProfileRequest = new SetUsersProfileRequest(this.mController.amsUsers, this.mController.mAccountsController.getConnectionUrl(this.mBrandId), this.mBrandId, msgUserProfile);
            SocketManager.getInstance().send((BaseSocketRequest)setUsersProfileRequest);
        }).execute();
    }
}

