/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.configuration.ConfigurableResource;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging.R;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CollectSDKConfigurationDataTask
extends BaseAmsAccountConnectionTask {
    private static final String TAG = "CollectConfigurationDataTask";
    private static final long MIN_DAYS_BEFORE_RESENDING_DATA = 2592000000L;

    private boolean isShouldExecute() {
        long currentTimeInMillis = System.currentTimeMillis();
        long mLastDatePublish = PreferenceManager.getInstance().getLongValue("configuration_data_publish_date_preference_key", "appLevelPreferences", -1L);
        LPLog.INSTANCE.d(TAG, "Android configuration currentTimeInMillis: " + currentTimeInMillis);
        LPLog.INSTANCE.d(TAG, "Android configuration mLastDatePublish: " + mLastDatePublish);
        return mLastDatePublish == -1L || mLastDatePublish - currentTimeInMillis >= 2592000000L;
    }

    public void execute() {
        if (!this.isShouldExecute()) {
            LPLog.INSTANCE.d(TAG, "Android configuration should not execute");
            this.mCallback.onTaskSuccess();
            return;
        }
        AmsConnectionAnalytics.collectSDKConfigurationDataTaskStart();
        new Thread(() -> {
            HashMap booleans = Configuration.scanXmlIdsAndNames(R.bool.class);
            HashMap colors = Configuration.scanXmlIdsAndNames(R.color.class);
            HashMap integers = Configuration.scanXmlIdsAndNames(R.integer.class);
            HashMap dimensions = Configuration.scanXmlIdsAndNames(R.dimen.class);
            String sb = "SDKConfiguration: " + this.printList(booleans, ConfigurableResource.ResourceType.Boolean) + this.printList(integers, ConfigurableResource.ResourceType.Integer) + this.printList(dimensions, ConfigurableResource.ResourceType.Dimension);
            LPLog.INSTANCE.d(TAG, "Android configuration is: " + sb);
            AmsConnectionAnalytics.collectSDKConfigurationDataTaskEnd();
            PreferenceManager.getInstance().setLongValue("configuration_data_publish_date_preference_key", "appLevelPreferences", System.currentTimeMillis());
            LPLog.INSTANCE.d(TAG, "Android configuration setLongValue: " + System.currentTimeMillis());
            this.mCallback.onTaskSuccess();
        }).start();
    }

    private StringBuilder printList(HashMap<Integer, String> resources, ConfigurableResource.ResourceType resourceType) {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<Integer, String>> resourceEntries = resources.entrySet();
        for (Map.Entry<Integer, String> resourceEntry : resourceEntries) {
            String resourceName = resourceEntry.getValue();
            sb.append(" configurationId= ").append(resourceName).append(" value= ").append(switch (resourceType) {
                case ConfigurableResource.ResourceType.Integer -> String.valueOf(Configuration.getInteger((int)resourceEntry.getKey()));
                case ConfigurableResource.ResourceType.Dimension -> String.valueOf(Configuration.getDimension((int)resourceEntry.getKey()));
                case ConfigurableResource.ResourceType.Boolean -> String.valueOf(Configuration.getBoolean((int)resourceEntry.getKey()));
                default -> "unknown value";
            }).append("\n");
        }
        return sb;
    }

    @Override
    public String getName() {
        return TAG;
    }
}

