/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.Infra;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.callbacks.AuthCallBack;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.model.Consumer;
import com.liveperson.infra.model.errors.AuthError;
import com.liveperson.infra.model.types.FailureReason;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsAccount;
import com.liveperson.messaging.model.AmsConnectionAnalytics;
import com.liveperson.messaging.model.AmsUsers;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IdpTask
extends BaseAmsAccountConnectionTask {
    private static final String TAG = "IdpTask";
    private final AmsUsers mAmsUsers;
    private AccountsController mAccountsController;
    private String mHostVersion;

    public IdpTask(AccountsController accountsController, AmsUsers amsUsers, String hostVersion) {
        this.mHostVersion = hostVersion;
        this.mAccountsController = accountsController;
        this.mAmsUsers = amsUsers;
    }

    public void execute() {
        boolean performSteUp;
        LPLog.INSTANCE.d(TAG, "Running IDP task...");
        AmsConnectionAnalytics.idpTaskStart();
        LPAuthenticationParams auth = this.mAccountsController.getLPAuthenticationParams(this.mBrandId);
        if (auth == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000C7, "getLPAuthenticationParams: getLPAuthenticationParams returns null for brand with id: " + this.mBrandId);
            this.mCallback.onTaskError(TaskType.IDP, LpError.IDP, new NullPointerException("Auth of defined brand id: " + this.mBrandId + " is null"));
            return;
        }
        if (Infra.instance.getConsumerManager().getActiveConsumer() != null && (auth.getAuthType() == LPAuthenticationType.SIGN_UP || Infra.instance.getConsumerManager().isAuthenticated())) {
            Infra.instance.getConsumerManager().setIsAuthenticated();
            this.onTaskComplete();
            LPLog.INSTANCE.d(TAG, "Not sending Idp request -> mark IdpTask completed");
            return;
        }
        List<String> certificates = this.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        AmsAccount account = this.mAccountsController.getAccount(this.mBrandId);
        String unAuthConnectorId = account == null ? null : account.getConnectorId();
        String authConnectorId = account == null ? null : account.getAuthConnectorId();
        boolean bl = performSteUp = account != null && account.isPerformStepUp();
        if (performSteUp) {
            this.backupOldConsumerId();
        }
        if (!performSteUp && account != null && account.getLPAuthenticationParams() != null && TextUtils.isEmpty((CharSequence)account.getLPAuthenticationParams().getIssuerDisplayName())) {
            authConnectorId = null;
        }
        Infra.instance.getConsumerManager().login(auth, this.getIdpDomain(), this.mHostVersion, certificates, unAuthConnectorId, authConnectorId, performSteUp, new AuthCallBack(){

            public void onAuthSuccess(@NonNull Consumer consumer) {
                LPLog.INSTANCE.d(IdpTask.TAG, "onAuthSuccess: Consumer: " + LPLog.INSTANCE.mask((Object)consumer));
                IdpTask.this.mAmsUsers.updateConsumerId(IdpTask.this.mBrandId, consumer.getConsumerId());
                IdpTask.this.onTaskComplete();
            }

            public void onConsumerSwitch(@NotNull Consumer oldConsumer, @NotNull Consumer newConsumer) {
                IdpTask.this.switchUser(oldConsumer, newConsumer);
                IdpTask.this.mAmsUsers.setStepUpConsumerId(oldConsumer.getConsumerId());
                IdpTask.this.mAmsUsers.updateConsumerId(IdpTask.this.mBrandId, newConsumer.getConsumerId());
                IdpTask.this.onTaskComplete();
            }

            public void onAuthFailed(@NotNull AuthError error) {
                if (error != null) {
                    LPLog.INSTANCE.d(IdpTask.TAG, "onAuthFailed: error: " + error.toString());
                    IdpTask.this.mCallback.onTaskError(TaskType.IDP, LpError.IDP, (FailureReason)error.getFailureReason(), error.getException());
                }
            }
        });
    }

    private String getIdpDomain() {
        String idpDomain = this.mAccountsController.getServiceUrl(this.mBrandId, "idp");
        if (TextUtils.isEmpty((CharSequence)idpDomain)) {
            idpDomain = PreferenceManager.getInstance().getStringValue("idp", this.mBrandId, null);
        }
        if (TextUtils.isEmpty((CharSequence)idpDomain)) {
            String asyncMessagingEnt = this.mAccountsController.getServiceUrl(this.mBrandId, "asyncMessagingEnt");
            idpDomain = asyncMessagingEnt.replaceFirst("msg", "idp");
        }
        return idpDomain;
    }

    private void backupOldConsumerId() {
        Consumer oldConsumer = Infra.instance.getConsumerManager().getActiveConsumer();
        if (oldConsumer != null && oldConsumer.getLpAuthenticationParams().getAuthType().equals((Object)LPAuthenticationType.UN_AUTH)) {
            this.mAmsUsers.setStepUpConsumerId(oldConsumer.getConsumerId());
        }
    }

    private void switchUser(Consumer oldConsumer, Consumer newConsumer) {
        String consumerId = newConsumer.getConsumerId();
        String oldConsumerId = oldConsumer.getConsumerId();
        MessagingFactory.getInstance().getController().liteLogout(this.mBrandId, oldConsumerId, consumerId);
    }

    private void onTaskComplete() {
        AmsAccount account = this.mAccountsController.getAccount(this.mBrandId);
        if (account != null) {
            account.sendAuthenticationCompletedStatus();
            if (!ForegroundService.getInstance().isBrandForeground(this.mBrandId)) {
                account.resetConsumerAuthState();
            }
        }
        AmsConnectionAnalytics.idpTaskEnd();
        this.mCallback.onTaskSuccess();
    }

    @Override
    public String getName() {
        return TAG;
    }
}

