/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.api.request.SubscribeMessagingEvents;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.network.socket.ResponseCallback;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.network.socket.requests.SubscribeMessagingEventsRequest;
import com.liveperson.messaging.offline.OfflineMessagingManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/liveperson/messaging/commands/tasks/OfflineModeSubscriptionRequestCallback;", "Lcom/liveperson/infra/network/socket/ResponseCallback;", "Lcom/liveperson/api/request/SubscribeMessagingEvents$Response;", "request", "Lcom/liveperson/messaging/network/socket/requests/SubscribeMessagingEventsRequest;", "controller", "Lcom/liveperson/messaging/Messaging;", "requestedDialogId", "", "(Lcom/liveperson/messaging/network/socket/requests/SubscribeMessagingEventsRequest;Lcom/liveperson/messaging/Messaging;Ljava/lang/String;)V", "onError", "", "onSuccess", "data", "messaging_release"})
final class OfflineModeSubscriptionRequestCallback
implements ResponseCallback<SubscribeMessagingEvents.Response> {
    @NotNull
    private final SubscribeMessagingEventsRequest request;
    @NotNull
    private final Messaging controller;
    @NotNull
    private final String requestedDialogId;

    public OfflineModeSubscriptionRequestCallback(@NotNull SubscribeMessagingEventsRequest request, @NotNull Messaging controller, @NotNull String requestedDialogId) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)requestedDialogId, (String)"requestedDialogId");
        this.request = request;
        this.controller = controller;
        this.requestedDialogId = requestedDialogId;
    }

    public void onSuccess(@Nullable SubscribeMessagingEvents.Response data) {
        DataBaseExecutor.execute(() -> OfflineModeSubscriptionRequestCallback.onSuccess$lambda$0(this));
        this.request.removeCallback(this);
    }

    public void onError() {
        this.request.removeCallback(this);
    }

    private static final void onSuccess$lambda$0(OfflineModeSubscriptionRequestCallback this$0) {
        Dialog currentActiveDialog;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Dialog dialog = currentActiveDialog = this$0.controller.amsDialogs.getActiveDialog();
        if (Intrinsics.areEqual((Object)(dialog != null ? dialog.getDialogId() : null), (Object)this$0.requestedDialogId)) {
            OfflineMessagingManager offlineManager = this$0.controller.getOfflineManager();
            offlineManager.setSubscribedToActiveDialog(true);
            offlineManager.processOfflineMessages(currentActiveDialog);
        }
    }
}

