/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.hybrid;

import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.messaging.R;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.messaging.hybrid.commands.exceptions.ConnectionNotReadyException;
import com.liveperson.messaging.hybrid.commands.exceptions.IncorrectConversationHistoryStateException;
import com.liveperson.messaging.hybrid.commands.exceptions.SDKNotInitializedException;
import com.liveperson.messaging.hybrid.commands.exceptions.SDKNotLaunchedException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\u0001*\u0004\u0018\u00010\u0001H\u0000\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0001\u00a8\u0006\t"}, d2={"requireConnection", "Lcom/liveperson/messaging/Messaging;", "requireConnectionController", "Lcom/liveperson/messaging/controller/ConnectionsController;", "requireConversationViewParams", "Lcom/liveperson/infra/ConversationViewParams;", "requireForegroundState", "requireInitialization", "requireStateToSendMessage", "messaging_release"})
@JvmName(name="HybridSDKUtils")
public final class HybridSDKUtils {
    @NotNull
    public static final ConnectionsController requireConnectionController(@NotNull Messaging $this$requireConnectionController) {
        Intrinsics.checkNotNullParameter((Object)$this$requireConnectionController, (String)"<this>");
        ConnectionsController connectionsController = $this$requireConnectionController.mConnectionController;
        if (connectionsController == null) {
            throw new SDKNotInitializedException("SDK is not fully initialized.");
        }
        return connectionsController;
    }

    @NotNull
    public static final ConversationViewParams requireConversationViewParams(@NotNull Messaging $this$requireConversationViewParams) {
        Intrinsics.checkNotNullParameter((Object)$this$requireConversationViewParams, (String)"<this>");
        ConversationViewParams conversationViewParams = $this$requireConversationViewParams.getConversationViewParams();
        if (conversationViewParams == null) {
            throw new SDKNotLaunchedException("SDK is wasn't launched. Conversation view params missing.");
        }
        return conversationViewParams;
    }

    @NotNull
    public static final Messaging requireInitialization(@Nullable Messaging $this$requireInitialization) {
        if ($this$requireInitialization == null || !$this$requireInitialization.isInitialized() || $this$requireInitialization.getActiveBrandId() == null) {
            throw new SDKNotInitializedException("SDK is not initialized.");
        }
        return $this$requireInitialization;
    }

    @NotNull
    public static final Messaging requireForegroundState(@NotNull Messaging $this$requireForegroundState) {
        Intrinsics.checkNotNullParameter((Object)$this$requireForegroundState, (String)"<this>");
        ForegroundService foregroundService = ForegroundService.getInstance();
        String string2 = $this$requireForegroundState.getActiveBrandId();
        Intrinsics.checkNotNull((Object)string2);
        if (!foregroundService.isBrandForeground(string2)) {
            throw new SDKNotLaunchedException("Conversation fragment is in background.");
        }
        return $this$requireForegroundState;
    }

    @NotNull
    public static final Messaging requireConnection(@NotNull Messaging $this$requireConnection) {
        Intrinsics.checkNotNullParameter((Object)$this$requireConnection, (String)"<this>");
        boolean isOfflineMessagingEnabled = Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled);
        ConnectionsController connectionController = HybridSDKUtils.requireConnectionController($this$requireConnection);
        String string2 = $this$requireConnection.getActiveBrandId();
        Intrinsics.checkNotNull((Object)string2);
        String brandId = string2;
        if (!connectionController.isUpdated(brandId) && !isOfflineMessagingEnabled) {
            throw new ConnectionNotReadyException("Connection is not ready to perform an operation.");
        }
        return $this$requireConnection;
    }

    @NotNull
    public static final Messaging requireStateToSendMessage(@NotNull Messaging $this$requireStateToSendMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$requireStateToSendMessage, (String)"<this>");
        Messaging controller = HybridSDKUtils.requireForegroundState(HybridSDKUtils.requireConnection($this$requireStateToSendMessage));
        ConversationViewParams params = HybridSDKUtils.requireConversationViewParams(controller);
        if (params.getHistoryConversationsStateToDisplay() == LPConversationsHistoryStateToDisplay.CLOSE) {
            throw new IncorrectConversationHistoryStateException("Could not perform operation. historyConversationsStateToDisplay is set to false");
        }
        return controller;
    }
}

