/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.offline;

import androidx.annotation.WorkerThread;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.FullMessageRow;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.offline.api.OfflineConversationRepository;
import com.liveperson.messaging.offline.api.OfflineDialogRepository;
import com.liveperson.messaging.offline.api.OfflineMessagesController;
import com.liveperson.messaging.offline.api.OfflineMessagesRepository;
import com.liveperson.messaging.wm.WelcomeMessageManager;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 ?2\u00020\u0001:\u0001?B-\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001f\u001a\u00020\u0011H\u0007J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\rH\u0003J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J\u0006\u0010&\u001a\u00020!J\u0018\u0010'\u001a\b\u0012\u0004\u0012\u00020(0$2\b\b\u0002\u0010)\u001a\u00020*H\u0007J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\rH\u0002J\u000e\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020(J\u0016\u00102\u001a\u00020!2\u0006\u0010.\u001a\u00020\r2\u0006\u00103\u001a\u00020\rJ+\u00104\u001a\u00020!2\u0006\u0010/\u001a\u00020\r2\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u000607j\u0002`8\u0018\u000106H\u0096\u0001J\u0011\u00109\u001a\u00020!2\u0006\u0010)\u001a\u00020*H\u0096\u0001J\u0011\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020-H\u0096\u0001J\f\u0010<\u001a\u00020!*\u00020(H\u0003J\u001a\u0010=\u001a\u00020!*\u00020(2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020-0,H\u0003R\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0011X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0012\u0010\u0016\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0018\u0010\u0017\u001a\u00020\u0011X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00118G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010\u001e\u001a\u00020\u00118G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/liveperson/messaging/offline/OfflineMessagingManager;", "Lcom/liveperson/messaging/offline/api/OfflineMessagesController;", "offlineMessagesController", "offlineConversationRepository", "Lcom/liveperson/messaging/offline/api/OfflineConversationRepository;", "offlineDialogRepository", "Lcom/liveperson/messaging/offline/api/OfflineDialogRepository;", "offlineMessagesRepository", "Lcom/liveperson/messaging/offline/api/OfflineMessagesRepository;", "welcomeMessageManager", "Lcom/liveperson/messaging/wm/WelcomeMessageManager;", "(Lcom/liveperson/messaging/offline/api/OfflineMessagesController;Lcom/liveperson/messaging/offline/api/OfflineConversationRepository;Lcom/liveperson/messaging/offline/api/OfflineDialogRepository;Lcom/liveperson/messaging/offline/api/OfflineMessagesRepository;Lcom/liveperson/messaging/wm/WelcomeMessageManager;)V", "currentBrandId", "", "getCurrentBrandId", "()Ljava/lang/String;", "isFullySynced", "", "()Z", "setFullySynced", "(Z)V", "isOfflineModeEnabled", "isOfflineWelcomeMessageEnabled", "isSubscribedToActiveDialog", "setSubscribedToActiveDialog", "offlineModePCSBehavior", "", "getOfflineModePCSBehavior", "()I", "shouldCreateConversationAfterPCS", "shouldShowPCSOptions", "areOfflineMessagesExist", "clearOfflineConversation", "", "targetId", "clearPendingOfflineMessages", "Lcom/liveperson/infra/database/DataBaseCommand;", "Ljava/lang/Void;", "createNewConversationIfNeeded", "getOrCreateOfflineDialog", "Lcom/liveperson/messaging/model/Dialog;", "requestId", "", "loadOfflineMessages", "", "Lcom/liveperson/messaging/model/FullMessageRow;", "brandId", "dialogId", "processOfflineMessages", "activeDialog", "removePendingOfflineMessage", "eventId", "resolveActiveDialog", "callback", "Lcom/liveperson/infra/ICallback;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "sendNewConversationRequest", "sendOfflineMessage", "message", "proceedPCSFlow", "sendOfflineMessages", "messages", "Companion", "messaging_release"})
@SourceDebugExtension(value={"SMAP\nOfflineMessagingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfflineMessagingManager.kt\ncom/liveperson/messaging/offline/OfflineMessagingManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1855#2,2:325\n1295#3,2:327\n1#4:329\n*S KotlinDebug\n*F\n+ 1 OfflineMessagingManager.kt\ncom/liveperson/messaging/offline/OfflineMessagingManager\n*L\n239#1:325,2\n277#1:327,2\n*E\n"})
public final class OfflineMessagingManager
implements OfflineMessagesController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OfflineMessagesController offlineMessagesController;
    @NotNull
    private final OfflineConversationRepository offlineConversationRepository;
    @NotNull
    private final OfflineDialogRepository offlineDialogRepository;
    @NotNull
    private final OfflineMessagesRepository offlineMessagesRepository;
    @NotNull
    private final WelcomeMessageManager welcomeMessageManager;
    private static final int BEHAVIOR_DO_NOTHING = 0;
    private static final int BEHAVIOR_CLEAR_OFFLINE_MESSAGES = 1;
    private static final int BEHAVIOR_RESOLVE_PCS_DIALOG = 2;
    private static final long OFFLINE_CONVERSATION_REQUEST_ID = 0L;
    @NotNull
    private static final String TAG = "OfflineManager";

    public OfflineMessagingManager(@NotNull OfflineMessagesController offlineMessagesController, @NotNull OfflineConversationRepository offlineConversationRepository, @NotNull OfflineDialogRepository offlineDialogRepository, @NotNull OfflineMessagesRepository offlineMessagesRepository, @NotNull WelcomeMessageManager welcomeMessageManager) {
        Intrinsics.checkNotNullParameter((Object)offlineMessagesController, (String)"offlineMessagesController");
        Intrinsics.checkNotNullParameter((Object)offlineConversationRepository, (String)"offlineConversationRepository");
        Intrinsics.checkNotNullParameter((Object)offlineDialogRepository, (String)"offlineDialogRepository");
        Intrinsics.checkNotNullParameter((Object)offlineMessagesRepository, (String)"offlineMessagesRepository");
        Intrinsics.checkNotNullParameter((Object)welcomeMessageManager, (String)"welcomeMessageManager");
        this.offlineMessagesController = offlineMessagesController;
        this.offlineConversationRepository = offlineConversationRepository;
        this.offlineDialogRepository = offlineDialogRepository;
        this.offlineMessagesRepository = offlineMessagesRepository;
        this.welcomeMessageManager = welcomeMessageManager;
    }

    @Override
    @NotNull
    public String getCurrentBrandId() {
        return this.offlineMessagesController.getCurrentBrandId();
    }

    @Override
    public boolean isFullySynced() {
        return this.offlineMessagesController.isFullySynced();
    }

    @Override
    public void setFullySynced(boolean bl) {
        this.offlineMessagesController.setFullySynced(bl);
    }

    @Override
    public boolean isOfflineModeEnabled() {
        return this.offlineMessagesController.isOfflineModeEnabled();
    }

    @Override
    public boolean isOfflineWelcomeMessageEnabled() {
        return this.offlineMessagesController.isOfflineWelcomeMessageEnabled();
    }

    @Override
    public boolean isSubscribedToActiveDialog() {
        return this.offlineMessagesController.isSubscribedToActiveDialog();
    }

    @Override
    public void setSubscribedToActiveDialog(boolean bl) {
        this.offlineMessagesController.setSubscribedToActiveDialog(bl);
    }

    @Override
    public int getOfflineModePCSBehavior() {
        return this.offlineMessagesController.getOfflineModePCSBehavior();
    }

    @Override
    public void resolveActiveDialog(@NotNull String dialogId, @Nullable ICallback<Integer, Exception> callback) {
        Intrinsics.checkNotNullParameter((Object)dialogId, (String)"dialogId");
        this.offlineMessagesController.resolveActiveDialog(dialogId, callback);
    }

    @Override
    public void sendNewConversationRequest(long requestId) {
        this.offlineMessagesController.sendNewConversationRequest(requestId);
    }

    @Override
    public void sendOfflineMessage(@NotNull FullMessageRow message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.offlineMessagesController.sendOfflineMessage(message);
    }

    @JvmOverloads
    @NotNull
    public final DataBaseCommand<Dialog> getOrCreateOfflineDialog(long requestId) {
        DataBaseCommand.QueryCommand queryCommand = () -> OfflineMessagingManager.getOrCreateOfflineDialog$lambda$0(this, requestId);
        return new DataBaseCommand(queryCommand);
    }

    public static /* synthetic */ DataBaseCommand getOrCreateOfflineDialog$default(OfflineMessagingManager offlineMessagingManager, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        return offlineMessagingManager.getOrCreateOfflineDialog(l);
    }

    public final void processOfflineMessages(@NotNull Dialog activeDialog) {
        Intrinsics.checkNotNullParameter((Object)activeDialog, (String)"activeDialog");
        DataBaseExecutor.execute(() -> OfflineMessagingManager.processOfflineMessages$lambda$1(this, activeDialog));
    }

    public final void createNewConversationIfNeeded() {
        DataBaseExecutor.execute(() -> OfflineMessagingManager.createNewConversationIfNeeded$lambda$5(this));
    }

    @NotNull
    public final DataBaseCommand<Void> clearPendingOfflineMessages() {
        return new DataBaseCommand(() -> OfflineMessagingManager.clearPendingOfflineMessages$lambda$6(this));
    }

    public final void removePendingOfflineMessage(@NotNull String brandId, @NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        this.offlineMessagesRepository.removePendingOfflineMessage(brandId, eventId);
    }

    private final List<FullMessageRow> loadOfflineMessages(String brandId, String dialogId) {
        this.offlineMessagesRepository.updateOfflineMessagesDialogId(dialogId);
        return this.offlineMessagesRepository.loadOfflineMessagesExcept(brandId, this.offlineMessagesRepository.getPendingOfflineMessages(brandId));
    }

    @WorkerThread
    private final void proceedPCSFlow(Dialog $this$proceedPCSFlow) {
        LPLog.INSTANCE.d(TAG, "Handling active PCS dialog.");
        this.offlineMessagesRepository.removeOfflineWelcomeMessage();
        int dialogBehavior = this.offlineMessagesController.getOfflineModePCSBehavior();
        switch (dialogBehavior) {
            case 0: {
                String string2 = $this$proceedPCSFlow.getBrandId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"brandId");
                String string3 = $this$proceedPCSFlow.getDialogId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"dialogId");
                List<FullMessageRow> offlineMessages = this.loadOfflineMessages(string2, string3);
                this.sendOfflineMessages($this$proceedPCSFlow, offlineMessages);
                break;
            }
            case 1: {
                String string4 = $this$proceedPCSFlow.getBrandId();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"brandId");
                String string5 = $this$proceedPCSFlow.getDialogId();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"dialogId");
                List<FullMessageRow> offlineMessages = this.loadOfflineMessages(string4, string5);
                Iterable $this$forEach$iv = offlineMessages;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FullMessageRow it = (FullMessageRow)element$iv;
                    boolean bl = false;
                    String string6 = it.getMessagingChatMessage().getEventId();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"it.messagingChatMessage.eventId");
                    this.offlineMessagesRepository.removeMessage(string6);
                }
                String string7 = $this$proceedPCSFlow.getDialogId();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"dialogId");
                this.offlineMessagesRepository.triggerUpdateMessagesForDialogId(string7);
                String string8 = $this$proceedPCSFlow.getTargetId();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"targetId");
                this.clearOfflineConversation(string8);
                break;
            }
            case 2: {
                String string9 = $this$proceedPCSFlow.getDialogId();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"dialogId");
                this.offlineMessagesController.resolveActiveDialog(string9, null);
                break;
            }
            default: {
                LPLog.INSTANCE.d(TAG, "Unsupported PCS dialog behavior value: " + dialogBehavior + ". Sending messages as is");
                String string10 = $this$proceedPCSFlow.getBrandId();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"brandId");
                String string11 = $this$proceedPCSFlow.getDialogId();
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"dialogId");
                List<FullMessageRow> offlineMessages = this.loadOfflineMessages(string10, string11);
                this.sendOfflineMessages($this$proceedPCSFlow, offlineMessages);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final void sendOfflineMessages(Dialog $this$sendOfflineMessages, List<? extends FullMessageRow> messages) {
        void $this$forEach$iv;
        Set pendingOfflineMessages = CollectionsKt.toMutableSet((Iterable)this.offlineMessagesRepository.getPendingOfflineMessages(this.getCurrentBrandId()));
        Sequence sequence = SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)messages), (Function1)((Function1)new Function1<FullMessageRow, Boolean>((Set<String>)pendingOfflineMessages){
            final /* synthetic */ Set<String> $pendingOfflineMessages;
            {
                this.$pendingOfflineMessages = $pendingOfflineMessages;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull FullMessageRow it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$pendingOfflineMessages.contains(it.getMessagingChatMessage().getEventId());
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FullMessageRow row = (FullMessageRow)element$iv;
            boolean bl = false;
            MessagingChatMessage chatMessage = row.getMessagingChatMessage();
            LPLog.INSTANCE.d(TAG, "Sending offline message: " + LPLog.INSTANCE.mask((Object)chatMessage));
            String string2 = chatMessage.getEventId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"chatMessage.eventId");
            pendingOfflineMessages.add(string2);
            this.offlineMessagesController.sendOfflineMessage(row);
        }
        String string3 = $this$sendOfflineMessages.getBrandId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"brandId");
        this.offlineMessagesRepository.setPendingOfflineMessages(string3, pendingOfflineMessages);
        String string4 = $this$sendOfflineMessages.getTargetId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"targetId");
        this.clearOfflineConversation(string4);
    }

    @WorkerThread
    public final boolean areOfflineMessagesExist() {
        return this.offlineMessagesRepository.areOfflineMessagesExists(this.getCurrentBrandId());
    }

    @WorkerThread
    private final void clearOfflineConversation(String targetId) {
        LPLog.INSTANCE.d(TAG, "Clear offline dialog and conversation");
        this.offlineDialogRepository.clearOfflineDialog(targetId);
        this.offlineConversationRepository.clearOfflineConversation(targetId);
    }

    @JvmName(name="shouldCreateConversationAfterPCS")
    public final boolean shouldCreateConversationAfterPCS() {
        return this.getOfflineModePCSBehavior() == 2;
    }

    @JvmName(name="shouldShowPCSOptions")
    public final boolean shouldShowPCSOptions() {
        return this.getOfflineModePCSBehavior() == 1;
    }

    @JvmOverloads
    @NotNull
    public final DataBaseCommand<Dialog> getOrCreateOfflineDialog() {
        return OfflineMessagingManager.getOrCreateOfflineDialog$default(this, 0L, 1, null);
    }

    private static final Dialog getOrCreateOfflineDialog$lambda$0(OfflineMessagingManager this$0, long $requestId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String brandId = this$0.offlineMessagesController.getCurrentBrandId();
        String targetId = this$0.offlineMessagesController.getCurrentBrandId();
        Conversation conversation = this$0.offlineConversationRepository.getOrCreateOfflineConversation(targetId, brandId, $requestId);
        OfflineDialogRepository offlineDialogRepository = this$0.offlineDialogRepository;
        String string2 = conversation.getConversationId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"conversation.conversationId");
        return offlineDialogRepository.getOrCreateOfflineDialog(targetId, brandId, string2, $requestId);
    }

    private static final void processOfflineMessages$lambda$1(OfflineMessagingManager this$0, Dialog $activeDialog) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$activeDialog, (String)"$activeDialog");
        OfflineMessagesRepository offlineMessagesRepository = this$0.offlineMessagesRepository;
        String string2 = $activeDialog.getBrandId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"activeDialog.brandId");
        boolean areOfflineMessagesExist = offlineMessagesRepository.areOfflineMessagesExists(string2);
        if (!areOfflineMessagesExist) {
            LPLog.INSTANCE.d(TAG, "No offline messages found. Skipping offline messages processing.");
            String string3 = $activeDialog.getTargetId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"activeDialog.targetId");
            this$0.clearOfflineConversation(string3);
            return;
        }
        DialogType dialogType = $activeDialog.getDialogType();
        if ((dialogType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[dialogType.ordinal()]) == 1) {
            this$0.proceedPCSFlow($activeDialog);
        } else {
            String string4 = $activeDialog.getBrandId();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"activeDialog.brandId");
            String string5 = $activeDialog.getDialogId();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"activeDialog.dialogId");
            List<FullMessageRow> offlineMessages = this$0.loadOfflineMessages(string4, string5);
            this$0.sendOfflineMessages($activeDialog, offlineMessages);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void createNewConversationIfNeeded$lambda$5(OfflineMessagingManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!this$0.offlineMessagesController.isOfflineModeEnabled()) {
            LPLog.INSTANCE.d("OfflineManager", "Offline mode is disabled. Skipping sending offline messages.");
            return;
        }
        brandId = this$0.offlineMessagesController.getCurrentBrandId();
        if (((CharSequence)brandId).length() == 0) {
            LPLog.INSTANCE.d("OfflineManager", "Brand id is empty. Skipping sending offline messages.");
            return;
        }
        areOfflineMessagesExist = this$0.offlineMessagesRepository.areOfflineMessagesExists(brandId);
        if (!areOfflineMessagesExist) {
            LPLog.INSTANCE.d("OfflineManager", "No offline messages found. Skipping creation of new conversation.");
            return;
        }
        var4_3 = this$0.offlineDialogRepository.getCachedActiveDialog();
        if (var4_3 == null) ** GOTO lbl-1000
        it = var6_4 = var4_3;
        $i$a$-takeUnless-OfflineMessagingManager$createNewConversationIfNeeded$1$activeDialog$1 = false;
        v0 = var5_8 = Intrinsics.areEqual((Object)it.getDialogId(), (Object)"OFFLINE_DIALOG") == false ? var6_4 : null;
        if (var5_8 == null) ** GOTO lbl-1000
        it = var7_5 = var5_8;
        $i$a$-takeUnless-OfflineMessagingManager$createNewConversationIfNeeded$1$activeDialog$2 = false;
        v1 = var6_4 = Intrinsics.areEqual((Object)it.getDialogId(), (Object)"TEMP_DIALOG") == false ? var7_5 : null;
        if (var6_4 == null) ** GOTO lbl-1000
        it = var8_7 = var6_4;
        $i$a$-takeUnless-OfflineMessagingManager$createNewConversationIfNeeded$1$activeDialog$3 = false;
        v2 = var7_5 = it.isClosed() == false ? var8_7 : null;
        if (var7_5 != null) {
            v3 = var7_5;
        } else lbl-1000:
        // 4 sources

        {
            v3 = activeDialog = this$0.offlineDialogRepository.queryRealActiveDialog(brandId);
        }
        if (activeDialog == null) {
            dialog = (Dialog)OfflineMessagingManager.getOrCreateOfflineDialog$default(this$0, 0L, 1, null).executeSynchronously();
            LPLog.INSTANCE.d("OfflineManager", "Sending new conversation request for offline dialog: " + dialog);
            this$0.offlineMessagesController.sendNewConversationRequest(0L);
        }
    }

    private static final Void clearPendingOfflineMessages$lambda$6(OfflineMessagingManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LPLog.INSTANCE.d(TAG, "Started removing pending offline messages");
        try {
            this$0.offlineMessagesRepository.removePendingOfflineMessages(this$0.getCurrentBrandId());
            LPLog.INSTANCE.d(TAG, "Pending offline messages successfully deleted");
        }
        catch (Throwable ex) {
            LPLog.INSTANCE.d(TAG, "Error occurred while clearing pending offline messages.");
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/liveperson/messaging/offline/OfflineMessagingManager$Companion;", "", "()V", "BEHAVIOR_CLEAR_OFFLINE_MESSAGES", "", "BEHAVIOR_DO_NOTHING", "BEHAVIOR_RESOLVE_PCS_DIALOG", "OFFLINE_CONVERSATION_REQUEST_ID", "", "TAG", "", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DialogType.values().length];
            try {
                nArray[DialogType.POST_SURVEY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

