/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.utils;

import com.liveperson.api.response.types.ConversationState;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.model.LPWelcomeMessage;
import com.liveperson.infra.model.PushMessage;
import com.liveperson.infra.model.types.NotificationType;
import com.liveperson.infra.preferences.PushMessagePreferences;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.ConversationUtils;
import com.liveperson.messaging.wm.WelcomeMessageManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u0007H\u0002\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u0007H\u0002\u001a*\u0010\t\u001a\u00020\n*\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0001\u001a\u001b\u0010\u000f\u001a\u00020\n*\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0082\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\u00a8\u0006\u0012"}, d2={"TAG", "", "isForEveryConversation", "", "Lcom/liveperson/infra/model/LPWelcomeMessage;", "(Lcom/liveperson/infra/model/LPWelcomeMessage;)Z", "getProactiveMessageId", "Lcom/liveperson/messaging/Messaging;", "retrieveProactiveMessageIdToShow", "showInitialMessageIfNeeded", "", "umsConversations", "", "Lcom/liveperson/messaging/model/ConversationData;", "incaConversations", "withHistoryClearenceFlag", "block", "Lkotlin/Function0;", "messaging_release"})
@JvmName(name="InitialMessageUtils")
@SourceDebugExtension(value={"SMAP\nInitialMessageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InitialMessageUtils.kt\ncom/liveperson/messaging/utils/InitialMessageUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n80#1,14:151\n80#1,14:165\n1747#2,3:141\n1747#2,3:145\n1747#2,3:148\n1#3:144\n*S KotlinDebug\n*F\n+ 1 InitialMessageUtils.kt\ncom/liveperson/messaging/utils/InitialMessageUtils\n*L\n62#1:151,14\n68#1:165,14\n27#1:141,3\n34#1:145,3\n37#1:148,3\n*E\n"})
public final class InitialMessageUtils {
    @NotNull
    private static final String TAG = "InitialMessageUtils";

    @JvmName(name="showInitialMessageIfNeeded")
    public static final void showInitialMessageIfNeeded(@NotNull Messaging $this$showInitialMessageIfNeeded, @NotNull List<? extends ConversationData> umsConversations, @Nullable List<? extends ConversationData> incaConversations) {
        Collection $i$f$any4;
        WelcomeMessageManager welcomeMessageManager;
        AmsConversations conversationsRepository;
        block37: {
            block36: {
                boolean isClosedInInca;
                boolean isClosedInUMS;
                Object nonSyncedConversation;
                block35: {
                    boolean bl;
                    block34: {
                        Object object;
                        boolean hasOpenConversation;
                        Object it;
                        Object element$iv;
                        Iterator iterator;
                        block33: {
                            Intrinsics.checkNotNullParameter((Object)$this$showInitialMessageIfNeeded, (String)"<this>");
                            Intrinsics.checkNotNullParameter(umsConversations, (String)"umsConversations");
                            Iterable $this$any$iv = umsConversations;
                            boolean $i$f$any2 = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v0 = false;
                            } else {
                                iterator = $this$any$iv.iterator();
                                while (iterator.hasNext()) {
                                    element$iv = iterator.next();
                                    it = (ConversationData)element$iv;
                                    boolean bl2 = false;
                                    if (!(((ConversationData)it).state == ConversationState.OPEN)) continue;
                                    v0 = true;
                                    break block33;
                                }
                                v0 = hasOpenConversation = false;
                            }
                        }
                        if (hasOpenConversation) {
                            LPLog.INSTANCE.d(TAG, "Consumer has an active conversation. Skipping adding proactive/welcome message");
                            return;
                        }
                        AmsConversations $i$f$any2 = $this$showInitialMessageIfNeeded.amsConversations;
                        if ($i$f$any2 != null && (iterator = $i$f$any2.getActiveConversation($this$showInitialMessageIfNeeded.getActiveBrandId())) != null && (element$iv = (Conversation)iterator.executeSynchronously()) != null) {
                            Object it2 = it = element$iv;
                            boolean bl3 = false;
                            object = ((Conversation)it2).getState() == ConversationState.OPEN ? it : null;
                        } else {
                            object = null;
                        }
                        nonSyncedConversation = object;
                        Iterable $this$any$iv = umsConversations;
                        boolean $i$f$any3 = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                ConversationData it3 = (ConversationData)element$iv2;
                                boolean bl4 = false;
                                Object object2 = nonSyncedConversation;
                                if (!(Intrinsics.areEqual((Object)it3.conversationId, (Object)(object2 != null ? ((Conversation)object2).getConversationId() : null)) && it3.state != ConversationState.OPEN)) continue;
                                bl = true;
                                break block34;
                            }
                            bl = false;
                        }
                    }
                    isClosedInUMS = bl;
                    Iterable $this$any$iv = umsConversations;
                    boolean $i$f$any4 = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ConversationData it = (ConversationData)element$iv;
                            boolean bl5 = false;
                            Object object = nonSyncedConversation;
                            if (!(Intrinsics.areEqual((Object)it.conversationId, (Object)(object != null ? ((Conversation)object).getConversationId() : null)) && it.state != ConversationState.OPEN)) continue;
                            v4 = true;
                            break block35;
                        }
                        v4 = isClosedInInca = false;
                    }
                }
                if (nonSyncedConversation != null && !isClosedInUMS && !isClosedInInca) {
                    LPLog.INSTANCE.d(TAG, "Consumer has an active conversation locally. Skipping adding proactive/welcome message");
                    return;
                }
                if ($this$showInitialMessageIfNeeded.getConversationViewParams().getHistoryConversationsStateToDisplay() == LPConversationsHistoryStateToDisplay.CLOSE) {
                    LPLog.INSTANCE.d(TAG, "Conversation params filtering is set to closed conversation. Skipping adding proactive/welcome message");
                    return;
                }
                AmsConversations amsConversations = $this$showInitialMessageIfNeeded.amsConversations;
                if (amsConversations == null) {
                    LPLog.INSTANCE.d(TAG, "Ams conversation is null");
                    return;
                }
                conversationsRepository = amsConversations;
                welcomeMessageManager = $this$showInitialMessageIfNeeded.getWelcomeMessageManager();
                if (welcomeMessageManager == null) break block36;
                String string2 = $this$showInitialMessageIfNeeded.getActiveBrandId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"activeBrandId");
                if ((welcomeMessageManager = welcomeMessageManager.getWelcomeMessage(string2)) != null) break block37;
            }
            return;
        }
        WelcomeMessageManager welcomeMessage = welcomeMessageManager;
        String pushMessageId = InitialMessageUtils.retrieveProactiveMessageIdToShow($this$showInitialMessageIfNeeded);
        boolean hasConversation = !((Collection)umsConversations).isEmpty() || !(($i$f$any4 = (Collection)incaConversations) == null || $i$f$any4.isEmpty());
        ConversationUtils conversationUtils = new ConversationUtils($this$showInitialMessageIfNeeded);
        if (pushMessageId != null) {
            LPLog.INSTANCE.d(TAG, "Showing proactive message");
            conversationUtils.displayOutboundCampaignMessage($this$showInitialMessageIfNeeded.getActiveBrandId(), pushMessageId);
        } else if (InitialMessageUtils.isForEveryConversation((LPWelcomeMessage)welcomeMessage)) {
            LPLog.INSTANCE.d(TAG, "Showing welcome message for each conversation");
            Messaging $this$withHistoryClearenceFlag$iv = $this$showInitialMessageIfNeeded;
            $i$f$withHistoryClearenceFlag = false;
            if (!$this$withHistoryClearenceFlag$iv.getClearHistoryFlag($this$withHistoryClearenceFlag$iv.getActiveBrandId())) {
                LPLog.INSTANCE.d(TAG, "History is not cleared. Showing welcome message");
                $i$a$-withHistoryClearenceFlag-InitialMessageUtils$showInitialMessageIfNeeded$1 = false;
                conversationUtils.addWelcomeMessageRequest($this$showInitialMessageIfNeeded.getActiveBrandId());
            } else if (!Configuration.getBoolean((int)R.bool.lp_hide_welcome_message_on_clear_history)) {
                LPLog.INSTANCE.d(TAG, "lp_hide_welcome_message_on_clear_history is not enabled. Showing welcome message");
                $i$a$-withHistoryClearenceFlag-InitialMessageUtils$showInitialMessageIfNeeded$1 = false;
                conversationUtils.addWelcomeMessageRequest($this$showInitialMessageIfNeeded.getActiveBrandId());
            } else {
                LPLog.INSTANCE.d(TAG, "History is cleare and lp_hide_welcome_message_on_clear_history. Skipping welcome message");
            }
        } else if (!hasConversation && !conversationsRepository.isHistoryExistForConsumer($this$showInitialMessageIfNeeded.getActiveBrandId())) {
            LPLog.INSTANCE.d(TAG, "Showing welcome message for the first conversation");
            Messaging $this$withHistoryClearenceFlag$iv = $this$showInitialMessageIfNeeded;
            $i$f$withHistoryClearenceFlag = false;
            if (!$this$withHistoryClearenceFlag$iv.getClearHistoryFlag($this$withHistoryClearenceFlag$iv.getActiveBrandId())) {
                LPLog.INSTANCE.d(TAG, "History is not cleared. Showing welcome message");
                $i$a$-withHistoryClearenceFlag-InitialMessageUtils$showInitialMessageIfNeeded$2 = false;
                conversationUtils.addWelcomeMessageRequest($this$showInitialMessageIfNeeded.getActiveBrandId());
            } else if (!Configuration.getBoolean((int)R.bool.lp_hide_welcome_message_on_clear_history)) {
                LPLog.INSTANCE.d(TAG, "lp_hide_welcome_message_on_clear_history is not enabled. Showing welcome message");
                $i$a$-withHistoryClearenceFlag-InitialMessageUtils$showInitialMessageIfNeeded$2 = false;
                conversationUtils.addWelcomeMessageRequest($this$showInitialMessageIfNeeded.getActiveBrandId());
            } else {
                LPLog.INSTANCE.d(TAG, "History is cleare and lp_hide_welcome_message_on_clear_history. Skipping welcome message");
            }
        } else {
            LPLog.INSTANCE.d(TAG, "Skipping showing message");
        }
    }

    private static final void withHistoryClearenceFlag(Messaging $this$withHistoryClearenceFlag, Function0<Unit> block) {
        boolean $i$f$withHistoryClearenceFlag = false;
        if (!$this$withHistoryClearenceFlag.getClearHistoryFlag($this$withHistoryClearenceFlag.getActiveBrandId())) {
            LPLog.INSTANCE.d(TAG, "History is not cleared. Showing welcome message");
            block.invoke();
        } else if (!Configuration.getBoolean((int)R.bool.lp_hide_welcome_message_on_clear_history)) {
            LPLog.INSTANCE.d(TAG, "lp_hide_welcome_message_on_clear_history is not enabled. Showing welcome message");
            block.invoke();
        } else {
            LPLog.INSTANCE.d(TAG, "History is cleare and lp_hide_welcome_message_on_clear_history. Skipping welcome message");
        }
    }

    private static final boolean isForEveryConversation(LPWelcomeMessage $this$isForEveryConversation) {
        return $this$isForEveryConversation.getMessageFrequency() == LPWelcomeMessage.MessageFrequency.EVERY_CONVERSATION;
    }

    private static final String getProactiveMessageId(Messaging $this$getProactiveMessageId) {
        String string2;
        if (PushMessagePreferences.INSTANCE.isPushNotificationClicked()) {
            string2 = PushMessagePreferences.INSTANCE.getClickedNotificationId();
        } else if (Configuration.getBoolean((int)R.bool.show_outbound_in_app_message)) {
            String string3 = $this$getProactiveMessageId.getActiveBrandId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"activeBrandId");
            string2 = PushMessagePreferences.INSTANCE.getLatestNotificationIdForBrand(string3);
        } else {
            string2 = null;
        }
        return string2;
    }

    private static final String retrieveProactiveMessageIdToShow(Messaging $this$retrieveProactiveMessageIdToShow) {
        String pushMessageId = InitialMessageUtils.getProactiveMessageId($this$retrieveProactiveMessageIdToShow);
        CharSequence charSequence = pushMessageId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            LPLog.INSTANCE.d(TAG, "No clicked proactive message found.");
            return null;
        }
        String string2 = $this$retrieveProactiveMessageIdToShow.getActiveBrandId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"activeBrandId");
        PushMessage message = PushMessagePreferences.INSTANCE.getCachedPushMessage(pushMessageId, string2);
        if (message == null) {
            LPLog.INSTANCE.d(TAG, "No push message found for id " + pushMessageId);
            return null;
        }
        if (message.isExpired()) {
            LPLog.INSTANCE.d(TAG, "Requested proactive for id " + pushMessageId + " is expired");
            return null;
        }
        NotificationType notificationType = message.getNotificationType();
        return switch (notificationType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()]) {
            case -1 -> {
                LPLog.INSTANCE.d(TAG, "Can't define message type for required push message id: " + pushMessageId + ". Skipping showing proactive message");
                yield null;
            }
            case 1 -> {
                LPLog.INSTANCE.d(TAG, "Clicked push notification is a regular one. Skipping showing proactive message");
                yield null;
            }
            default -> pushMessageId;
        };
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            try {
                nArray[NotificationType.REGULAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

