/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.utils;

import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.patterns.PatternsCompat;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0005"}, d2={"containsLink", "", "text", "", "findFirstWebLink", "messaging_release"})
@JvmName(name="SDKLinkUtils")
public final class SDKLinkUtils {
    public static final boolean containsLink(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return SDKLinkUtils.findFirstWebLink(text) != null;
    }

    @Nullable
    public static final String findFirstWebLink(@NotNull String text) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String brandRegex = Configuration.getString((int)R.string.lp_bubble_url_links_regex);
        Object object2 = brandRegex;
        if (object2 == null || StringsKt.isBlank((CharSequence)object2)) {
            Pattern pattern = PatternsCompat.AUTOLINK_WEB_URL;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"AUTOLINK_WEB_URL");
            object2 = pattern;
            object = new Regex((Pattern)object2);
        } else {
            try {
                Intrinsics.checkNotNullExpressionValue((Object)brandRegex, (String)"brandRegex");
                object2 = new Regex(brandRegex);
            }
            catch (PatternSyntaxException exception) {
                Pattern pattern = PatternsCompat.AUTOLINK_WEB_URL;
                Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"AUTOLINK_WEB_URL");
                Pattern pattern2 = pattern;
                object2 = new Regex(pattern2);
            }
            object = object2;
        }
        Regex resultRegex = object;
        MatchResult matchResult = Regex.find$default((Regex)resultRegex, (CharSequence)text, (int)0, (int)2, null);
        return matchResult != null ? matchResult.getValue() : null;
    }
}

