/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.wm.core;

import android.content.ContentValues;
import android.content.SharedPreferences;
import com.liveperson.messaging.wm.core.MultiProcessEditor;
import com.liveperson.messaging.wm.core.MultiProcessEditorHelper;
import com.liveperson.messaging.wm.core.ValueReader;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0016J(\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00192\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/liveperson/messaging/wm/core/MultiProcessStore;", "Landroid/content/SharedPreferences;", "editorHelper", "Lcom/liveperson/messaging/wm/core/MultiProcessEditorHelper;", "valueReader", "Lcom/liveperson/messaging/wm/core/ValueReader;", "(Lcom/liveperson/messaging/wm/core/MultiProcessEditorHelper;Lcom/liveperson/messaging/wm/core/ValueReader;)V", "contains", "", "key", "", "edit", "Landroid/content/SharedPreferences$Editor;", "getAll", "", "getBoolean", "defValue", "getFloat", "", "getInt", "", "getLong", "", "getString", "getStringSet", "", "defValues", "registerOnSharedPreferenceChangeListener", "", "listener", "Landroid/content/SharedPreferences$OnSharedPreferenceChangeListener;", "unregisterOnSharedPreferenceChangeListener", "messaging_release"})
public final class MultiProcessStore
implements SharedPreferences {
    @NotNull
    private final MultiProcessEditorHelper editorHelper;
    @NotNull
    private final ValueReader valueReader;

    public MultiProcessStore(@NotNull MultiProcessEditorHelper editorHelper, @NotNull ValueReader valueReader) {
        Intrinsics.checkNotNullParameter((Object)editorHelper, (String)"editorHelper");
        Intrinsics.checkNotNullParameter((Object)valueReader, (String)"valueReader");
        this.editorHelper = editorHelper;
        this.valueReader = valueReader;
    }

    @NotNull
    public Map<String, ?> getAll() {
        return this.valueReader.getAllValues();
    }

    @Nullable
    public String getString(@NotNull String key, @Nullable String defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.valueReader.readValue(key, defValue);
    }

    @Nullable
    public Set<String> getStringSet(@NotNull String key, @Nullable Set<String> defValues) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.valueReader.readValue(key, defValues);
    }

    public int getInt(@NotNull String key, int defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ((Number)this.valueReader.readValue(key, defValue)).intValue();
    }

    public long getLong(@NotNull String key, long defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ((Number)this.valueReader.readValue(key, defValue)).longValue();
    }

    public float getFloat(@NotNull String key, float defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ((Number)this.valueReader.readValue(key, Float.valueOf(defValue))).floatValue();
    }

    public boolean getBoolean(@NotNull String key, boolean defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.valueReader.readValue(key, defValue);
    }

    public boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.valueReader.containsValue(key);
    }

    @NotNull
    public SharedPreferences.Editor edit() {
        return new MultiProcessEditor(new ContentValues(), this.editorHelper);
    }

    public void registerOnSharedPreferenceChangeListener(@NotNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    public void unregisterOnSharedPreferenceChangeListener(@NotNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }
}

