package com.liveperson.api.response.model;

/**
 * Created by oferd on 8/10/15.
 */
public enum ContentType {
    text_html("text/html"),
    text_plain("text/plain"),
    text_structured_content("text/structured-content"),
    hosted_file("hosted/file"),
    application_json("application/json"),
	forms_secure_invitation("forms/secure-invitation"),
	forms_secure_submission("forms/secure-submission");

    private String text;

    ContentType(String text) {
        this.text = text;
    }

    public static ContentType fromString(String text) throws IllegalArgumentException {
        if (text != null) {
            for (ContentType b : ContentType.values()) {
                if (text.equalsIgnoreCase(b.text)) {
                    return b;
                }
            }
        }
        throw new IllegalArgumentException("No constant with text " + text + " found");
    }

    public String getText() {
        return this.text;
    }

	/**
	 * Return whether this content type is a file type
	 * @return
	 */
    public boolean isFile() {
        return (this == hosted_file);
    }

	/**
	 * Returns whether this content type is a simple text file
	 * @return
	 */
	public boolean isSimpleText(){
		return (this == text_plain);
	}

    /**
     * Returns whether this content type is a simple text file
     * @return
     */
    public boolean isHtml(){
        return (this == text_html);
    }

	/**
	 * Returns whether this content type is a forms_secure_invitation
	 * @return
	 */
	public boolean isFormInvitation(){
		return (this == forms_secure_invitation);
	}

	/**
	 * Returns whether this content type is a forms_secure_submission
	 * @return
	 */
	public boolean isFormSubmission(){
		return (this == forms_secure_submission);
	}

}
