package com.liveperson.api.response.model;

import android.net.Uri;

import org.json.JSONObject;

/**
 * Created by shiranr on 06/07/2016.
 */
public class QueryParams {
	public static final String TEMP_URL = "temp_url_sig";
	public static final String EXPIRE_TIME = "temp_url_expires";


	public String tempURL;
	public String expireTime;

	public QueryParams(JSONObject innerBody) {
		tempURL = innerBody.optString(TEMP_URL);
		expireTime = innerBody.optString(EXPIRE_TIME);
	}

	public QueryParams(Uri uri){
		this.tempURL = uri.getQueryParameter(TEMP_URL);
		this.expireTime = uri.getQueryParameter(EXPIRE_TIME);
	}

	public void appendQueryParameter(Uri.Builder builder) {
		builder.appendQueryParameter(TEMP_URL, tempURL);
		builder.appendQueryParameter(EXPIRE_TIME, expireTime);

	}
}
