package com.liveperson.messaging;

import com.liveperson.api.response.events.ExConversationChangeNotification;
import com.liveperson.api.response.events.MessagingEventNotification;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.infra.network.socket.GeneralResponseHandler;
import com.liveperson.infra.network.socket.ResponseMap;

import static com.liveperson.infra.errors.ErrorCode.ERR_000000BC;

/**
 * Created by shiranr on 8/15/16.
 */
public class GeneralMessagingResponseHandler extends GeneralResponseHandler {

    private static final String TAG = "GeneralMessagingResponseHandler";
    private final Messaging mController;

    GeneralMessagingResponseHandler(Messaging controller){
        mController = controller;
    }

    protected BaseResponseHandler createInstance(String responseType) {
        if (ExConversationChangeNotification.CONVERSATION_CHANGE_NOTIFICATION_TYPE.equals(responseType)) {
	        LPLog.INSTANCE.d(ResponseMap.RESPONSE_TAG + TAG, "Creating general response - ExConversationChangeNotification - for message type :" + responseType);
            return ExConversationChangeNotification.getResponseHandler(mController);
        }

        if (responseType.equals(MessagingEventNotification.Companion.getType())) {
            LPLog.INSTANCE.d(ResponseMap.RESPONSE_TAG + TAG, "Creating general response - MessagingEventNotification - for message type :" + responseType);
            return MessagingEventNotification.Companion.getResponseHandler(mController);
        }

        LPLog.INSTANCE.e(ResponseMap.RESPONSE_TAG + TAG, ERR_000000BC, "Couldn't find general response for message type :" + responseType);
        return null;
    }
}
