package com.liveperson.messaging.commands;

import androidx.annotation.NonNull;

import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingChatMessage;

public class SendImageCommand extends SendFileCommand {
	/**
	 * Creates a command for sending messages
	 *
	 * @param controller
	 * @param targetId
	 * @param brandId
	 * @param contentType
	 * @param thumbnailPath
	 * @param filePath
	 * @param fileTypeExtension
	 * @param message
	 */
	public SendImageCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String filePath, String fileTypeExtension, MaskedMessage message) {
		super(controller, targetId, brandId, contentType, thumbnailPath, filePath, fileTypeExtension, message);
	}

	@NonNull
	protected MessagingChatMessage.MessageType getMessageType(MaskedMessage message) {
		return message.isMasked()? MessagingChatMessage.MessageType.CONSUMER_IMAGE_MASKED : MessagingChatMessage.MessageType.CONSUMER_IMAGE;
	}

}
