package com.liveperson.messaging.model;

import android.text.TextUtils;

import com.liveperson.infra.log.LPLog;

import org.json.JSONException;
import org.json.JSONObject;

import static com.liveperson.infra.errors.ErrorCode.ERR_000000D2;

/**
 * Created by ofira on 3/19/16.
 */
public class AcUserData {

    private static final String TAG = "AcUserData";

    private static final String KEY_PICTURE_URL = "pictureUrl";
    private static final String KEY_NICKNAME = "nickname";
    private static final String KEY_FULLNAME = "fullName";
    private static final String KEY_EMPLOYEE_ID = "employeeId";
    private static final String KEY_EMAIL = "email";

    private String mPictureUrl;
    private String mNickName;
    private String mFullName;
    private String mFirstName;
    private String mLastName;
    private String mEmployeeId;
    private String mEmail;


    public AcUserData(String profileStr){

        try {
            JSONObject profileObj = new JSONObject(profileStr);
            mPictureUrl = profileObj.optString(KEY_PICTURE_URL);
            mNickName = profileObj.optString(KEY_NICKNAME);
            mFirstName = "";
            mLastName = "";
            mFullName = profileObj.optString(KEY_FULLNAME);
            if(!TextUtils.isEmpty(mFullName)){
                String[] splitName = mFullName.split("\\s+");
                mFirstName = splitName[0];
                if(splitName.length >= 2){
                    mLastName = splitName[1];
                }
            }

            mEmployeeId = profileObj.optString(KEY_EMPLOYEE_ID);
            mEmail = profileObj.optString(KEY_EMAIL);
        }catch (JSONException je){
            LPLog.INSTANCE.e(TAG, ERR_000000D2, "JSONException", je);
        }
    }


    public String getPictureUrl() {
        return mPictureUrl;
    }

    public String getNickName() {
        return mNickName;
    }

    public String getFullName() {
        return mFullName;
    }

    public String getEmployeeId() {
        return mEmployeeId;
    }

    public String getEmail() {
        return mEmail;
    }

    public String getFirstName() {
        return mFirstName;
    }

    public String getLastName() {
        return mLastName;
    }
}
