package com.liveperson.messaging.network.socket.requests;

import android.text.TextUtils;

import com.liveperson.api.request.SubscribeExConversations;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.api.request.BaseAMSSocketRequest;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by eyalv on 11/15/15.
 */
public class SubscribeExConversationsRequest extends BaseAMSSocketRequest<SubscribeExConversations.Response, SubscribeExConversationsRequest> {

	private static final String TAG = "SubscribeExConversationsRequest";

	private String consumerId;
    private long maxLastUpdatedTime = -1;
    private long minLastUpdatedTime;
    private String[] agentIds = {""};
    private String brandId;
    private int maxETTR = 0;
    private ConnectionsController mConnectionController;


    public SubscribeExConversationsRequest(ConnectionsController connectionController, long minLastUpdatedTime, String brandId, String socketUrl, String consumerId) {
        super(socketUrl);
        mConnectionController = connectionController;
        this.minLastUpdatedTime = minLastUpdatedTime;
        this.brandId = brandId;
        this.consumerId = consumerId;
    }

    @Override
    protected String getData() {
        String[] conversationStages = {ConversationState.OPEN.name(), ConversationState.CLOSE.name(), ConversationState.LOCKED.name()};
        return new SubscribeExConversations(consumerId, maxLastUpdatedTime, minLastUpdatedTime, agentIds, brandId, maxETTR, conversationStages).toJsonString(getRequestId());
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }

    @Override
    protected BaseResponseHandler<SubscribeExConversations.Response, SubscribeExConversationsRequest> getResponseHandler() {
        return new BaseResponseHandler<SubscribeExConversations.Response, SubscribeExConversationsRequest>() {

            @Override
            public String getAPIResponseType() {
                return SubscribeExConversations.Response.SUBSCRIBE_EX_CONVERSATIONS_RESPONSE_TYPE;
            }

            @Override
            protected SubscribeExConversations.Response parse(JSONObject jsonObject) throws JSONException {
                return new SubscribeExConversations.Response(jsonObject);
            }

            @Override
            protected boolean handle(SubscribeExConversations.Response responseData) {
                final String subscriptionId = ((SubscribeExConversations.Response.Body) responseData.getBody()).subscriptionId;
                if (TextUtils.isEmpty(subscriptionId)){
                    LPLog.INSTANCE.w(TAG, "No subscription Id! can't get updates!");
                    return true;
                }
                mConnectionController.setSubscription(brandId, subscriptionId);
                //First time after subscribe we go check if we have to update from INCA, this indicated its the first time after subscribe.
                mConnectionController.setFirstNotificationAfterSubscribe(brandId, true);
                return true;
            }
        };
    }
}
