package com.liveperson.messaging.structuredcontent.model.actions;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 6/6/17.
 */
public class PublishTextAction extends BaseAction {

	private static final String TAG = "PublishTextAction";

	private String mText;

	private JSONArray mMetadata;

	public PublishTextAction(JSONObject jsonObject, @Nullable JSONArray metadataJsonArray) throws JSONException {
		super(jsonObject);

		mText = jsonObject.getString(ElementType.TEXT);

		mMetadata = metadataJsonArray;
	}

	@Override
	public OnActionClickListener getOnClickListener(final Context context, final String brandId) {
		return () -> {
			// Send the text as a consumer message
			LPLog.INSTANCE.d(TAG, "onClick: sending text: " + LPLog.INSTANCE.mask(mText) + " with metadata: " + LPLog.INSTANCE.mask(mMetadata));
			MessagingFactory.getInstance().getController().sendMessage(brandId, brandId, mText, new DeliveryStatusUpdateInfo(mMetadata));
		};
	}

	@Override
	@NonNull
	public String toString() {
		return getClass().getSimpleName() + "(" + "\n";
	}

	@Override
	public void accept(ElementVisitor visitor) {
	}
}
