package com.liveperson.messaging.structuredcontent.model.elements.complex;

import androidx.annotation.Nullable;
import android.text.TextUtils;

import com.liveperson.messaging.structuredcontent.model.elements.BaseElement;
import com.liveperson.messaging.structuredcontent.model.elements.SimpleElement;
import com.liveperson.messaging.structuredcontent.parsers.ElementParser;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by nirni on 3/6/18.
 */

public abstract class ComplexElement extends SimpleElement {

	/**
	 * A list of all children elements
	 */
	protected List<BaseElement> mElementList;

	// Default elements key name. This field is for supporting complex element with elements list with difference key (e.g. QuickReplies has 'replies' key)
	private String mElementsKeyName = ElementType.ELEMENTS;

	public ComplexElement(String type) {
		super(type);
		mElementList = new ArrayList<>();
	}

	public ComplexElement(JSONObject jsonObject, @Nullable String elementsKeyName) throws JSONException {
		super(jsonObject);

		// Default is ELEMENTS unless received a different name
		if (!TextUtils.isEmpty(elementsKeyName)) {
			mElementsKeyName = elementsKeyName;
		}

		// Next element to be added
		BaseElement elementToAdd;

		mElementList = new ArrayList<>();

		JSONArray elements = jsonObject.getJSONArray(mElementsKeyName);
		for (int i = 0; i < elements.length(); i++) {

			JSONObject elementJSONObject = elements.getJSONObject(i);

			elementToAdd = ElementParser.parse(elementJSONObject);

			// If an element added, add it to the list
			if (elementToAdd != null) {
				mElementList.add(elementToAdd);
			}
		}

	}

	public ComplexElement(JSONObject jsonObject) throws JSONException {
		this(jsonObject, null);
	}

	public void addElement(SimpleElement element) {
		mElementList.add(element);
	}

	public List<BaseElement> getElementList() {
		return mElementList;
	}

}
