/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.pusher;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.requests.PushRequest;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.SynchronizedAuthenticationCompletedCallback;
import java.util.List;

public class RegisterPusherCommand
implements Command {
    private static final String TAG = "RegisterPusherCommand";
    private static final String PUSHER_URL = "https://%s/api/account/%s/device/register";
    private final Messaging mController;
    private final LPAuthenticationParams mLpAuthParams;
    private String mBrandId;
    private String mToken;
    private String mAppId;
    @Nullable
    private ICallback<Void, Exception> mRegistrationCompletedCallback;

    public RegisterPusherCommand(Messaging messagingController, String brandId, LPAuthenticationParams lpAuthParams) {
        this(messagingController, brandId, "", "", lpAuthParams, null);
    }

    public RegisterPusherCommand(Messaging messagingController, String brandId, String appId, String token, LPAuthenticationParams lpAuthParams, @Nullable ICallback<Void, Exception> registrationCompletedCallback) {
        this.mController = messagingController;
        this.mBrandId = brandId;
        this.mToken = token;
        this.mAppId = appId;
        this.mLpAuthParams = lpAuthParams;
        this.mRegistrationCompletedCallback = registrationCompletedCallback;
    }

    public void execute() {
        boolean isExecuting2;
        LPLog.INSTANCE.i(TAG, "execute with token " + LPLog.INSTANCE.mask((Object)this.mToken));
        if (TextUtils.isEmpty((CharSequence)this.mAppId)) {
            this.mAppId = PreferenceManager.getInstance().getStringValue("APP_ID_PREFERENCE_KEY", this.mBrandId, "");
        } else {
            PreferenceManager.getInstance().setStringValue("APP_ID_PREFERENCE_KEY", this.mBrandId, this.mAppId);
        }
        if (TextUtils.isEmpty((CharSequence)this.mToken)) {
            this.mToken = PreferenceManager.getInstance().getStringValue("PUSHER_DEVICE_TOKEN_PREFERENCE_KEY", this.mBrandId, "");
            if (TextUtils.isEmpty((CharSequence)this.mToken)) {
                LPLog.INSTANCE.w(TAG, "device token is empty. skip register pusher.");
                return;
            }
        } else {
            PreferenceManager.getInstance().setStringValue("PUSHER_DEVICE_TOKEN_PREFERENCE_KEY", this.mBrandId, this.mToken);
        }
        if (!(isExecuting2 = new SynchronizedAuthenticationCompletedCallback(this.mController.mAccountsController, this.mBrandId, new ICallback<Void, Exception>(){

            public void onSuccess(Void value) {
                List<String> certificates = ((RegisterPusherCommand)RegisterPusherCommand.this).mController.mAccountsController.getCertificatePinningKeys(RegisterPusherCommand.this.mBrandId);
                String pusherDomain = ((RegisterPusherCommand)RegisterPusherCommand.this).mController.mAccountsController.getServiceUrl(RegisterPusherCommand.this.mBrandId, "pusher");
                if (TextUtils.isEmpty((CharSequence)pusherDomain) && TextUtils.isEmpty((CharSequence)(pusherDomain = PreferenceManager.getInstance().getStringValue("pusher", RegisterPusherCommand.this.mBrandId, null)))) {
                    LPLog.INSTANCE.e(RegisterPusherCommand.TAG, ErrorCode.ERR_0000014C, "pusherDomain does not exists. Failed to register push");
                    if (RegisterPusherCommand.this.mRegistrationCompletedCallback != null) {
                        RegisterPusherCommand.this.mRegistrationCompletedCallback.onError((Throwable)new Exception("Pusher domain is empty!, SDK may not initialized!"));
                    }
                    return;
                }
                String pusherURL = String.format(RegisterPusherCommand.PUSHER_URL, pusherDomain, RegisterPusherCommand.this.mBrandId);
                String consumerId = ((RegisterPusherCommand)RegisterPusherCommand.this).mController.amsUsers.getConsumerId(RegisterPusherCommand.this.mBrandId);
                if (TextUtils.isEmpty((CharSequence)consumerId)) {
                    ((RegisterPusherCommand)RegisterPusherCommand.this).mController.amsUsers.getConsumerByBrandIDFromDB(RegisterPusherCommand.this.mBrandId).setPostQueryOnBackground(returnedConsumerId -> {
                        if (returnedConsumerId != null && !TextUtils.isEmpty((CharSequence)returnedConsumerId)) {
                            LPLog.INSTANCE.d(RegisterPusherCommand.TAG, "fetchConsumerIdAndSendRequest: got consumerId from DB (" + returnedConsumerId + "). get the unread message count with it...");
                            this.sendRequest(pusherURL, (String)returnedConsumerId, certificates);
                        } else {
                            LPLog.INSTANCE.w(RegisterPusherCommand.TAG, "fetchConsumerIdAndSendRequest: Cannot get user profile from DB. Quit get badge counter");
                            if (RegisterPusherCommand.this.mRegistrationCompletedCallback != null) {
                                RegisterPusherCommand.this.mRegistrationCompletedCallback.onError((Throwable)new Exception("Failed to register pusher. Error: Missing consumerID"));
                            }
                        }
                    }).execute();
                } else {
                    this.sendRequest(pusherURL, consumerId, certificates);
                }
            }

            public void onError(Exception exception) {
                if (RegisterPusherCommand.this.mRegistrationCompletedCallback != null) {
                    RegisterPusherCommand.this.mRegistrationCompletedCallback.onError((Throwable)exception);
                }
            }

            private void sendRequest(String pusherURL, String consumerId, List<String> certificates) {
                LPLog.INSTANCE.i(RegisterPusherCommand.TAG, "Running register pusher with token " + LPLog.INSTANCE.mask((Object)RegisterPusherCommand.this.mToken));
                String token = ((RegisterPusherCommand)RegisterPusherCommand.this).mController.mAccountsController.getToken(RegisterPusherCommand.this.mBrandId);
                if (TextUtils.isEmpty((CharSequence)token)) {
                    token = this.getTokenFromSharedPreferences();
                }
                new PushRequest(pusherURL, consumerId, RegisterPusherCommand.this.mAppId, RegisterPusherCommand.this.mToken, token, certificates).setCallback((ICallback)new ICallback<Void, Exception>(){

                    public void onSuccess(Void value) {
                        PreferenceManager.getInstance().setBooleanValue("IS_PUSHER_REGISTERED_PREFERENCE_KEY", RegisterPusherCommand.this.mBrandId, true);
                        PreferenceManager.getInstance().remove("CONSUMER_UNREGISTER_PUSHER_PREFERENCE_KEY", RegisterPusherCommand.this.mBrandId);
                        if (RegisterPusherCommand.this.mRegistrationCompletedCallback != null) {
                            RegisterPusherCommand.this.mRegistrationCompletedCallback.onSuccess((Object)value);
                        }
                    }

                    public void onError(Exception exception) {
                        if (RegisterPusherCommand.this.mRegistrationCompletedCallback != null) {
                            RegisterPusherCommand.this.mRegistrationCompletedCallback.onError((Throwable)exception);
                        }
                    }
                }).execute();
            }

            private String getTokenFromSharedPreferences() {
                String token;
                String decryptedToken = PreferenceManager.getInstance().getStringValue("account_token_enc", RegisterPusherCommand.this.mBrandId, null);
                if (TextUtils.isEmpty((CharSequence)decryptedToken)) {
                    token = PreferenceManager.getInstance().getStringValue("account_token", RegisterPusherCommand.this.mBrandId, null);
                    PreferenceManager.getInstance().remove("account_token", RegisterPusherCommand.this.mBrandId);
                } else {
                    token = DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)decryptedToken);
                }
                return token;
            }
        }).executeWithReturnValue()) && this.mLpAuthParams != null) {
            this.mController.connect(this.mBrandId, this.mLpAuthParams, null, true, false);
        }
    }
}

