/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.text.TextUtils;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.messaging.model.FileMessage;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.structuredcontent.model.elements.SimpleElement;
import com.liveperson.messaging.structuredcontent.parsers.ElementParser;
import org.json.JSONException;
import org.json.JSONObject;

public class FullMessageRow {
    private static final String TAG = "FullMessageRow";
    public static final String EXTRA_AGENT_AVATAR = "EXTRA_AGENT_AVATAR";
    private boolean isStructuredContentEmpty;
    private MessagingChatMessage messagingChatMessage;
    private String agentAvatar;
    private String agentNickName;
    private FileMessage fileMessage;
    private SimpleElement rootElement;

    public FullMessageRow(MessagingChatMessage messagingChatMessage, String agentAvatar, FileMessage fileMessage) {
        this.messagingChatMessage = messagingChatMessage;
        this.agentAvatar = agentAvatar;
        this.fileMessage = fileMessage;
    }

    public FullMessageRow(Cursor cursor) {
        long messageId = cursor.getLong(cursor.getColumnIndex("_id"));
        String originatorId = cursor.getString(cursor.getColumnIndex("originatorId"));
        String message = cursor.getString(cursor.getColumnIndex("text"));
        long timeStamp = cursor.getLong(cursor.getColumnIndex("timeStamp"));
        int typeInt = cursor.getInt(cursor.getColumnIndex("type"));
        MessagingChatMessage.MessageType type = MessagingChatMessage.MessageType.values()[typeInt];
        MessagingChatMessage.MessageState state = MessagingChatMessage.MessageState.values()[cursor.getInt(cursor.getColumnIndex("status"))];
        String dialogId = cursor.getString(cursor.getColumnIndex("dialogId"));
        String eventId = cursor.getString(cursor.getColumnIndex("eventId"));
        int serverSequence = cursor.getInt(cursor.getColumnIndex("serverSequence"));
        EncryptionVersion messageEncryptionVersion = EncryptionVersion.fromInt((int)cursor.getInt(cursor.getColumnIndex("message_encryptVer")));
        EncryptionVersion userEncryptionVersion = EncryptionVersion.fromInt((int)cursor.getInt(cursor.getColumnIndex("user_encryptVer")));
        this.agentAvatar = cursor.getString(cursor.getColumnIndex("profileImage"));
        this.agentAvatar = DBEncryptionHelper.decrypt((EncryptionVersion)userEncryptionVersion, (String)this.agentAvatar);
        this.agentNickName = cursor.getString(cursor.getColumnIndex("nickname"));
        this.agentNickName = DBEncryptionHelper.decrypt((EncryptionVersion)userEncryptionVersion, (String)this.agentNickName);
        this.messagingChatMessage = new MessagingChatMessage(originatorId, message, timeStamp, dialogId, eventId, type, state, messageEncryptionVersion);
        this.messagingChatMessage.setServerSequence(serverSequence);
        this.messagingChatMessage.setMessageId(messageId);
        if (this.messagingChatMessage.isFileType()) {
            this.fileMessage = FileMessage.fromCursor(cursor);
        }
    }

    public FileMessage getFileMessage() {
        return this.fileMessage;
    }

    public MessagingChatMessage getMessagingChatMessage() {
        return this.messagingChatMessage;
    }

    public String getAgentAvatar() {
        return this.agentAvatar;
    }

    public String getAgentNickName() {
        return this.agentNickName;
    }

    public void setAgentNickName(String agentNickName) {
        this.agentNickName = agentNickName;
    }

    public int newerThan(FullMessageRow newMessageRow) {
        boolean isNewerTime;
        boolean isSameSequence = this.messagingChatMessage.getServerSequence() == newMessageRow.getMessagingChatMessage().getServerSequence();
        boolean isSameDialogId = TextUtils.equals((CharSequence)this.messagingChatMessage.getDialogId(), (CharSequence)newMessageRow.getMessagingChatMessage().getDialogId());
        boolean needToCheckSeq = true;
        if (!TextUtils.isEmpty((CharSequence)this.messagingChatMessage.getEventId()) && !TextUtils.isEmpty((CharSequence)newMessageRow.getMessagingChatMessage().getEventId())) {
            needToCheckSeq = false;
        }
        boolean isSameEventId = TextUtils.equals((CharSequence)this.messagingChatMessage.getEventId(), (CharSequence)newMessageRow.getMessagingChatMessage().getEventId());
        boolean bl = isNewerTime = this.messagingChatMessage.getTimeStamp() > newMessageRow.getMessagingChatMessage().getTimeStamp();
        if (isSameEventId || needToCheckSeq && isSameSequence && isSameDialogId) {
            return 0;
        }
        if (isNewerTime) {
            return 1;
        }
        return -1;
    }

    public Bundle update(FullMessageRow newMessageRow) {
        Bundle bundle = new Bundle();
        bundle.putAll(this.messagingChatMessage.update(newMessageRow.getMessagingChatMessage()));
        if (this.fileMessage != null) {
            bundle.putAll(this.fileMessage.update(newMessageRow.getFileMessage()));
        } else if (newMessageRow.getFileMessage() != null) {
            bundle.putAll(newMessageRow.getFileMessage().getAllFileChanges());
            this.fileMessage = newMessageRow.getFileMessage();
        }
        if (!TextUtils.equals((CharSequence)this.agentAvatar, (CharSequence)newMessageRow.getAgentAvatar())) {
            this.agentAvatar = newMessageRow.getAgentAvatar();
            bundle.putString(EXTRA_AGENT_AVATAR, this.agentAvatar);
        }
        return bundle.isEmpty() ? null : bundle;
    }

    public static FullMessageRow generateUnreadIndicatorMessage(Context context, int numUnreadMessages, long timeStamp) {
        long messageId = -1L;
        String originatorId = null;
        String unreadMessagesBase = context.getResources().getQuantityString(R.plurals.lp_unread_message, numUnreadMessages);
        String message = String.format(unreadMessagesBase, numUnreadMessages);
        MessagingChatMessage.MessageType type = MessagingChatMessage.MessageType.UNREAD_INDICATOR;
        MessagingChatMessage.MessageState state = MessagingChatMessage.MessageState.RECEIVED;
        String convId = "";
        String eventId = "";
        int serverSequence = -1;
        MessagingChatMessage messagingChatMessage = new MessagingChatMessage(originatorId, message, timeStamp, convId, eventId, type, state, EncryptionVersion.NONE);
        messagingChatMessage.setServerSequence(serverSequence);
        messagingChatMessage.setMessageId(messageId);
        return new FullMessageRow(messagingChatMessage, null, null);
    }

    public static Bundle getUnreadIndicatorMessageDiff(FullMessageRow newUnreadIndicatorMessage) {
        Bundle bundle = new Bundle();
        bundle.putString("EXTRA_MESSAGE_TEXT", newUnreadIndicatorMessage.getMessagingChatMessage().getMessage());
        return bundle;
    }

    public static FullMessageRow getLoadingIndicatorMessage(Context context, long timeStamp, boolean setText) {
        long messageId = -1L;
        String originatorId = null;
        String message = setText ? context.getString(R.string.lp_still_loading_message) : "";
        MessagingChatMessage.MessageType type = MessagingChatMessage.MessageType.LOADING;
        MessagingChatMessage.MessageState state = MessagingChatMessage.MessageState.RECEIVED;
        String dialogId = "";
        String eventId = "";
        int serverSequence = -1;
        MessagingChatMessage messagingChatMessage = new MessagingChatMessage(originatorId, message, timeStamp, dialogId, eventId, type, state, EncryptionVersion.NONE);
        messagingChatMessage.setServerSequence(serverSequence);
        messagingChatMessage.setMessageId(messageId);
        return new FullMessageRow(messagingChatMessage, null, null);
    }

    public static Bundle getLoadingIndicatorMessageDiff(Context context) {
        Bundle bundle = new Bundle();
        bundle.putString("EXTRA_MESSAGE_TEXT", context.getString(R.string.lp_still_loading_message));
        return bundle;
    }

    public static FullMessageRow getLoadingHistoryIndicatorMessage(long timeStamp, String message) {
        long messageId = -1L;
        String originatorId = null;
        MessagingChatMessage.MessageType type = MessagingChatMessage.MessageType.LOADING;
        MessagingChatMessage.MessageState state = MessagingChatMessage.MessageState.RECEIVED;
        String convId = "";
        String eventId = "";
        int serverSequence = -1;
        MessagingChatMessage messagingChatMessage = new MessagingChatMessage(originatorId, message, timeStamp, convId, eventId, type, state, EncryptionVersion.NONE);
        messagingChatMessage.setServerSequence(serverSequence);
        messagingChatMessage.setMessageId(messageId);
        return new FullMessageRow(messagingChatMessage, null, null);
    }

    public static FullMessageRow generateAgentQuickReplyMessage(String quickReplyJsonString, long relatedAgentMessageTimestamp, String dialogId) {
        MessagingChatMessage.MessageType type = MessagingChatMessage.MessageType.AGENT_QUICK_REPLIES;
        MessagingChatMessage.MessageState state = MessagingChatMessage.MessageState.READ;
        long quickReplyMessageTimestamp = relatedAgentMessageTimestamp + 1L;
        MessagingChatMessage messagingChatMessage = new MessagingChatMessage(null, quickReplyJsonString, quickReplyMessageTimestamp, dialogId, "", type, state, EncryptionVersion.NONE);
        messagingChatMessage.setServerSequence(-1);
        messagingChatMessage.setMessageId(-1L);
        FullMessageRow message = new FullMessageRow(messagingChatMessage, null, null);
        LPLog.INSTANCE.d(TAG, "generateAgentQuickReplyMessage: add the quick replies json to the message");
        SimpleElement rootElement = null;
        try {
            JSONObject root = new JSONObject(quickReplyJsonString);
            rootElement = ElementParser.parse(root);
        }
        catch (JSONException e) {
            LPLog.INSTANCE.w(TAG, "parse: there is a problem parsing the structured content json", (Throwable)e);
        }
        message.setRootElement(rootElement);
        return message;
    }

    public SimpleElement getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(SimpleElement layoutElement) {
        this.rootElement = layoutElement;
    }

    public boolean isStructuredContentEmpty() {
        return this.isStructuredContentEmpty;
    }

    public void setStructuredContentEmpty(boolean structuredContentEmpty) {
        this.isStructuredContentEmpty = structuredContentEmpty;
    }
}

