/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.http;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.body.LPJSONObjectBody;
import com.liveperson.infra.network.http.request.HttpPostRequest;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.tasks.IdpTask;
import com.liveperson.messaging.model.AmsAccount;
import com.liveperson.messaging.network.http.IdpRequest;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class UnAuthRequest
extends IdpRequest {
    private static final String TAG = "UnAuthRequest";
    private static final String IDP_ANONYMOUS_URL = "https://%s/api/account/%s/anonymous/authorize";
    private String mConnectorId;

    public UnAuthRequest(AmsAccount account, String idpDomain, String brandId, LPAuthenticationParams lpAuthenticationParams, String hostVersion, IdpTask.IDPExceptionICallback callback, List<String> certificates, String connectorId) {
        super(account, idpDomain, brandId, lpAuthenticationParams, hostVersion, callback, certificates);
        this.mConnectorId = connectorId;
    }

    @Override
    public void execute() {
        this.sendUnAuthRequest();
    }

    private void sendUnAuthRequest() {
        String idpUrl = String.format(IDP_ANONYMOUS_URL, this.mIdpDomain, this.mBrandId);
        final HttpPostRequest unAuthJwtRequest = new HttpPostRequest(idpUrl);
        String nonAuthCode = this.mAccount.getNonAuthCode();
        if (!TextUtils.isEmpty((CharSequence)nonAuthCode)) {
            LPLog.INSTANCE.d(TAG, "Refresh anonymous token");
            JSONObject jsonBody = new JSONObject();
            try {
                jsonBody.put("id_token", (Object)nonAuthCode);
            }
            catch (JSONException e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000D0, "Error when sendUnAuthRequest: ", (Throwable)e);
            }
            LPJSONObjectBody body = new LPJSONObjectBody(jsonBody);
            unAuthJwtRequest.setBody((HttpRequestBody)body);
        } else {
            LPLog.INSTANCE.d(TAG, "New anonymous token");
        }
        unAuthJwtRequest.setCallback((ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String idpResponse) {
                LPLog.INSTANCE.d(UnAuthRequest.TAG, "onSuccess " + LPLog.INSTANCE.mask((Object)idpResponse));
                if (!TextUtils.isEmpty((CharSequence)idpResponse)) {
                    try {
                        JSONObject idpJson = new JSONObject(idpResponse);
                        String token = idpJson.getString("token");
                        UnAuthRequest.this.mAccount.setNonAuthCode(token);
                        HttpPostRequest httpPostRequest = UnAuthRequest.this.getHttpPostRequestForIDPV3(token);
                        UnAuthRequest.this.sendGeneralRequest(httpPostRequest);
                    }
                    catch (JSONException je) {
                        LPLog.INSTANCE.d(UnAuthRequest.TAG, "JSONException: ", (Throwable)je);
                        String errorMsg = "Error parsing onSuccess response: idp url = " + unAuthJwtRequest.getUrl() + ". Exception " + je.getMessage();
                        UnAuthRequest.this.sendErrorCallback(new Exception(errorMsg));
                    }
                }
            }

            public void onError(Exception exception) {
                LPLog.INSTANCE.w(UnAuthRequest.TAG, "Error: idp url = " + unAuthJwtRequest.getUrl() + ". Exception ", (Throwable)exception);
                String message = exception.getMessage();
                if (!TextUtils.isEmpty((CharSequence)message) && message.contains("2001") && !TextUtils.isEmpty((CharSequence)UnAuthRequest.this.mAccount.getNonAuthCode())) {
                    UnAuthRequest.this.mCallback.onError(TaskType.USER_EXPIRED, exception);
                } else {
                    UnAuthRequest.this.sendErrorCallback(exception);
                }
            }
        });
        this.sendGeneralRequest(unAuthJwtRequest);
    }

    @NonNull
    private HttpPostRequest getHttpPostRequestForIDPV3(String anonymousJwt) {
        JSONObject jsonBody = null;
        if (!TextUtils.isEmpty((CharSequence)anonymousJwt)) {
            jsonBody = this.getBodyForIDPJwtFlow(anonymousJwt);
        }
        LPLog.INSTANCE.d(TAG, "Idp json body: " + LPLog.INSTANCE.mask((Object)jsonBody));
        String IDP_URL = "https://%s/api/account/%s/app/%s/%s?v=3.0";
        String idpUrl = String.format(IDP_URL, this.mIdpDomain, this.mBrandId, this.mConnectorId, "authenticate");
        final HttpPostRequest httpPostRequest = new HttpPostRequest(idpUrl);
        LPJSONObjectBody body = new LPJSONObjectBody(jsonBody);
        httpPostRequest.setBody((HttpRequestBody)body);
        httpPostRequest.setCallback((ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String idpResponse) {
                LPLog.INSTANCE.d(UnAuthRequest.TAG, "onSuccess " + LPLog.INSTANCE.mask((Object)idpResponse));
                if (!TextUtils.isEmpty((CharSequence)idpResponse)) {
                    try {
                        JSONObject idpJson = new JSONObject(idpResponse);
                        String token = idpJson.getString("token");
                        UnAuthRequest.this.mCallback.onSuccess(token);
                    }
                    catch (JSONException je) {
                        LPLog.INSTANCE.d(UnAuthRequest.TAG, "JSONException: ", (Throwable)je);
                        String errorMsg = "idp url = " + httpPostRequest.getUrl() + ". Exception " + je.getMessage();
                        UnAuthRequest.this.sendErrorCallback(new Exception(errorMsg));
                    }
                }
            }

            public void onError(Exception e) {
                LPLog.INSTANCE.d(UnAuthRequest.TAG, "Error: idp url = " + httpPostRequest.getUrl() + ". Exception ", (Throwable)e);
                UnAuthRequest.this.sendErrorCallback(e);
            }
        });
        return httpPostRequest;
    }
}

