/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.general_requests;

import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.GetClock;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.messaging.utils.ClockUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ClockRequest
extends BaseAMSSocketRequest<GetClock.Response, ClockRequest> {
    private static final String TAG = "ClockRequest";
    private final String mBrandId;
    private ConnectionsController mConnectionController;

    public ClockRequest(ConnectionsController connectionController, String mSocketUrl, String brandId) {
        super(mSocketUrl);
        this.mBrandId = brandId;
        this.mConnectionController = connectionController;
    }

    protected String getData() {
        return new GetClock().toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<GetClock.Response, ClockRequest> getResponseHandler() {
        return new ClockResponseHandler();
    }

    public class ClockResponseHandler
    extends BaseResponseHandler<GetClock.Response, ClockRequest> {
        public String getAPIResponseType() {
            return GetClock.Response.GET_CLOCK_RESPONSE_TYPE;
        }

        protected GetClock.Response parse(JSONObject jsonObject) {
            GetClock.Response response = null;
            try {
                response = new GetClock.Response(jsonObject);
            }
            catch (JSONException e) {
                LPLog.INSTANCE.e(ClockRequest.TAG, ErrorCode.ERR_000000C3, "Error parsing get clock response", (Throwable)e);
            }
            return response;
        }

        protected boolean handle(GetClock.Response data) {
            long clockDiff = System.currentTimeMillis() - data.body.currentTime;
            LPLog.INSTANCE.d(ClockRequest.TAG, "The clock diff is " + clockDiff);
            ClockRequest.this.mConnectionController.setClockDiff(ClockRequest.this.mBrandId, clockDiff);
            ClockUtils.setClockDiff(clockDiff);
            return true;
        }
    }
}

