package com.liveperson.messaging;

import android.content.Context;

import com.liveperson.infra.statemachine.InitProcess;
import com.liveperson.infra.statemachine.LogoutProcess;
import com.liveperson.infra.statemachine.ShutDownProcess;

/**
 * Created by dudu on 2/8/16.
 */
public class MessagingFactory {
    protected static MessagingFactory instance;
    protected Messaging messagingController;

    protected MessagingFactory() {}

    public static MessagingFactory getInstance() {
        if (instance == null){
            synchronized (MessagingFactory.class){
                if (instance == null){
                    instance = new MessagingFactory();
                }
            }
        }
        return instance;
    }

    public synchronized void init(Context context, MessagingInitData initData, InitProcess initProcess) {
        initializeMessaging();
        messagingController.init(context, initData, initProcess);
    }

    private void initializeMessaging() {
        if (messagingController == null) {
            messagingController = new Messaging();
        }
    }

    public Messaging getController() {
        return messagingController;
    }

    public void shutDown(ShutDownProcess shutDownProcess) {
        messagingController.shutDown(shutDownProcess);
    }

    public void logout(Context context, MessagingInitData initData, LogoutProcess logoutProcess) {
        initializeMessaging();
        messagingController.logout(context, initData, logoutProcess);
    }

    public boolean isInitialized() {
        return messagingController.isInitialized();
    }

    public void initAnalyticsService(Context applicationContext, String brandId, String appId) {
        initializeMessaging();
        messagingController.initAnalyticsService(applicationContext, brandId, appId);
    }
}
