/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.request;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.liveperson.api.request.RequestConversation;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.CampaignInfo;
import com.liveperson.infra.utils.LocaleUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ConsumerRequestConversation
extends RequestConversation {
    private static final String MOBILE_APP_CONTEXT = "MobileAppContext";
    private static final String SHARK_CONTEXT = "SharkContext";
    private static final String CONTEXT = "context";
    private static final String TTR_DEF_NAME = "ttrDefName";
    private static final String APP_ID = "APP_ID";
    private static final String BRAND_ID = "brandId";
    private static final String SKILL_ID = "skillId";
    private static final String LANG = "lang";
    private static final String CAMPAIGN_INFO = "campaignInfo";
    private static final String CAMPAIGN_ID = "campaignId";
    private static final String ENGAGEMENT_ID = "engagementId";
    private static final String VISITOR_ID = "visitorId";
    private static final String SESSION_ID = "sessionId";
    private static final String CONVERSATION_CONTEXT_KEY = "conversationContext";
    public static final String INTERACTION_CONTEXT_ID = "interactionContextId";
    public String appId;
    public TTRType ttrType;
    public String brandId;
    public String skillId;
    public CampaignInfo mCampaignInfo;

    public ConsumerRequestConversation(String app_id, TTRType ttrType, String brandId, String skillId, @Nullable CampaignInfo campaignInfo) {
        this.ttrType = ttrType;
        this.appId = app_id;
        this.brandId = brandId;
        this.skillId = skillId;
        this.mCampaignInfo = campaignInfo;
    }

    @Override
    public String getMessageType() {
        return "cm.ConsumerRequestConversation";
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        JSONObject context = new JSONObject();
        context.put(APP_ID, (Object)this.appId);
        JSONObject convContext = new JSONObject();
        if (this.mCampaignInfo != null && this.mCampaignInfo.getCampaignId() != null && this.mCampaignInfo.getEngagementId() != null) {
            JSONObject campaignInfoObject = new JSONObject();
            campaignInfoObject.put(CAMPAIGN_ID, (Object)this.mCampaignInfo.getCampaignId());
            campaignInfoObject.put(ENGAGEMENT_ID, (Object)this.mCampaignInfo.getEngagementId());
            this.body.put(CAMPAIGN_INFO, (Object)campaignInfoObject);
            convContext.put("type", (Object)SHARK_CONTEXT);
            if (!TextUtils.isEmpty((CharSequence)this.mCampaignInfo.getContextId())) {
                convContext.put(INTERACTION_CONTEXT_ID, (Object)this.mCampaignInfo.getContextId());
            }
            if (this.mCampaignInfo.getSessionId() != null) {
                convContext.put(SESSION_ID, (Object)this.mCampaignInfo.getSessionId());
            }
            if (this.mCampaignInfo.getVisitorId() != null) {
                convContext.put(VISITOR_ID, (Object)this.mCampaignInfo.getVisitorId());
            }
        } else {
            convContext.put("type", (Object)MOBILE_APP_CONTEXT);
        }
        convContext.put(LANG, (Object)LocaleUtils.getInstance().getLocaleCode());
        this.body.put(CONVERSATION_CONTEXT_KEY, (Object)convContext);
        this.body.put(CONTEXT, (Object)context);
        this.body.put(TTR_DEF_NAME, (Object)this.ttrType.name());
        this.body.put(BRAND_ID, (Object)this.brandId);
        if (TextUtils.isEmpty((CharSequence)this.skillId)) {
            this.body.put(SKILL_ID, -1);
        } else {
            this.body.put(SKILL_ID, (Object)this.skillId);
        }
        json.put("body", (Object)this.body);
    }
}

